/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.io.IOException;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps.KWPSCommon;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.TopicExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class VolumeManager {
    private static final Logger log = LoggerFactory.getLogger(VolumeManager.class);
    private static final FsPermission TOPIC_VOLUME_PERMISSION = new FsPermission(493);
    private static final int MAX_RETRIES = 5;
    private final MapRFileSystem mfs;
    private final MapRUserInfo userInfo;
    private final Security.CredentialsMsg creds;

    public VolumeManager(MapRFileSystem mfs, Security.CredentialsMsg userCredentials) {
        this.mfs = mfs;
        this.userInfo = mfs.getUserInfo();
        if (userCredentials == null) {
            Security.CredentialsMsg.Builder msg = Security.CredentialsMsg.newBuilder().setUid(this.userInfo.GetUserID()).setUserName(this.userInfo.getUserName());
            for (int gid : this.userInfo.GetGroupIDList()) {
                msg.addGids(gid);
            }
            this.creds = msg.build();
        } else {
            this.creds = userCredentials;
        }
    }

    public void createVolume(String volumeName, String volumePath) throws IllegalArgumentException, IOException {
        int uid = this.userInfo.GetUserID();
        int gid = this.userInfo.GetGroupIDList()[0];
        CLDBProto.VolumeProperties volProps = CLDBProto.VolumeProperties.newBuilder().setVolumeName(volumeName).setOwnerId(uid).setRootDirUser(uid).setRootDirGroup(gid).build();
        CLDBProto.VolumeCreateRequest volumeCreateReq = CLDBProto.VolumeCreateRequest.newBuilder().setCreds(this.creds).setVolProperties(volProps).build();
        try {
            CLDBProto.VolumeCreateResponse resp = this.createVolume(volumeCreateReq);
            int status = resp.getStatus();
            if (status == 0) {
                String cluster = null;
                int mountStatus = this.mfs.mountVolume(cluster, volumeName, volumePath, this.userInfo.getUserName());
                if (mountStatus != 0) {
                    throw new IOException(KWPSCommon.errMsg(mountStatus, "Failed to mount volume '%s' at path '%s'", volumeName, volumePath));
                }
            } else {
                String errMsg = KWPSCommon.errMsg(status, "Failed to create volume '%s' at path '%s'.", volumeName, volumePath);
                switch (status) {
                    case 1: 
                    case 13: {
                        throw new TopicAuthorizationException(KWPSCommon.errMsg(status, "User does not have permission to create volumes for topics.", new Object[0]));
                    }
                    case 17: {
                        throw new TopicExistsException(errMsg);
                    }
                }
                throw new IOException(errMsg);
            }
            this.setPermissionWithRetry(volumePath);
            log.debug("Created volume: '{}' mounted at path '{}'.", (Object)volumeName, (Object)volumePath);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean isVolume(String topicName) throws IllegalArgumentException, IOException {
        try {
            String volumeName = KWPSCommon.getVolumeName(topicName);
            CLDBProto.VolumeLookupRequest lookupRequest = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setCreds(this.creds).build();
            CLDBProto.VolumeLookupResponse lookupResp = this.lookupVolume(lookupRequest);
            return lookupResp.getStatus() == 0;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean deleteVolume(String topicName) throws IllegalArgumentException, IOException {
        try {
            CLDBProto.VolumeRemoveRequest volumeRemove;
            CLDBProto.VolumeRemoveResponse removeResp;
            String volumeName = KWPSCommon.getVolumeName(topicName);
            CLDBProto.VolumeLookupRequest lookupRequest = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(volumeName).setCreds(this.creds).build();
            CLDBProto.VolumeLookupResponse lookupResp = this.lookupVolume(lookupRequest);
            int status = lookupResp.getStatus();
            if (status != 0) {
                throw new IOException(KWPSCommon.errMsg(status, "Error looking up topic volume '%s'.", volumeName));
            }
            CLDBProto.VolumeProperties volProps = lookupResp.getVolInfo().getVolProperties();
            if (volProps.getMounted()) {
                String volumeMountDir = volProps.getMountDir();
                Common.FidMsg parentFid = volProps.getParentFid();
                status = this.mfs.unmountVolume(null, volumeName, volumeMountDir, this.userInfo.getUserName(), parentFid.getCid(), parentFid.getCinum(), parentFid.getUniq());
                if (status != 0) {
                    throw new IOException(KWPSCommon.errMsg(status, "Failed to unmount topic volume '%s'.", volumeName));
                }
            }
            if ((removeResp = this.removeVolume(volumeRemove = CLDBProto.VolumeRemoveRequest.newBuilder().setVolumeName(volumeName).setCreds(this.creds).setForceRemove(true).build())).getStatus() != 0) {
                throw new IOException(KWPSCommon.errMsg(removeResp.getStatus(), "Failed to delete topic volume '%s'.", volumeName));
            }
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private CLDBProto.VolumeRemoveResponse removeVolume(CLDBProto.VolumeRemoveRequest volumeRemoveReq) throws Exception {
        byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeRemoveProc.getNumber(), (MessageLite)volumeRemoveReq, CLDBProto.VolumeRemoveResponse.class);
        return data == null ? null : CLDBProto.VolumeRemoveResponse.parseFrom((byte[])data);
    }

    private CLDBProto.VolumeCreateResponse createVolume(CLDBProto.VolumeCreateRequest volumeCreateReq) throws Exception {
        byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeCreateProc.getNumber(), (MessageLite)volumeCreateReq, CLDBProto.VolumeCreateResponse.class);
        return data == null ? null : CLDBProto.VolumeCreateResponse.parseFrom((byte[])data);
    }

    private CLDBProto.VolumeLookupResponse lookupVolume(CLDBProto.VolumeLookupRequest volumeLookupReq) throws Exception {
        byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volumeLookupReq, CLDBProto.VolumeLookupResponse.class);
        return data == null ? null : CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
    }

    private boolean setPermissionWithRetry(String volumePathStr) throws IOException {
        int retry = 0;
        int sleep = 100;
        int totalSleep = 0;
        while (true) {
            try {
                Path volumePath = new Path(volumePathStr);
                this.mfs.setPermission(volumePath, TOPIC_VOLUME_PERMISSION);
                return true;
            }
            catch (IOException e) {
                if (retry++ < 5) {
                    log.debug("Volume is not ready yet, retrying ({}) in {}ms", (Object)retry, (Object)sleep);
                    try {
                        Thread.sleep(sleep);
                        totalSleep += sleep;
                        sleep *= 2;
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new IOException("Topic volume isn't online after " + totalSleep + "ms.", e);
            }
            break;
        }
    }
}

