/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.kwps;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mapr.fs.ServiceWatcher;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BrokerWatcher
extends ServiceWatcher {
    private static final Logger log = LoggerFactory.getLogger(BrokerWatcher.class);
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private static final String DEFAULT_CLUSTER = "default-cluster";
    private static final String BROKERS_PATH_FORMAT = "/kafka-wire-protocol/%s/brokers";
    private final String brokersPath;
    private final Map<String, String> connectionProperties = new HashMap<String, String>();

    public BrokerWatcher(String zkConnectString, String zkClusterName) {
        this(zkConnectString, zkClusterName, Optional.empty());
    }

    public BrokerWatcher(String zkConnectString, String zkClusterName, Optional<String> kafkaCluster) {
        super(zkConnectString, zkClusterName);
        String kafkaClusterName = kafkaCluster.orElse(DEFAULT_CLUSTER);
        this.brokersPath = String.format(BROKERS_PATH_FORMAT, kafkaClusterName);
    }

    public Map<String, String> getConnectionProperties() throws Exception {
        StringBuilder bootstrapServers = new StringBuilder();
        log.info("Brokers path: {}.", (Object)this.brokersPath);
        ListIterator brokersItr = this.getChildren(this.brokersPath).listIterator();
        while (brokersItr.hasNext()) {
            this.readBrokerProps((String)brokersItr.next(), bootstrapServers);
        }
        if (bootstrapServers.length() > 0) {
            this.connectionProperties.put("bootstrap.servers", bootstrapServers.substring(1));
        }
        return this.connectionProperties;
    }

    private void readBrokerProps(String broker, StringBuilder bootstrapServers) throws Exception {
        String saslMechanism;
        String securityProtocol;
        byte[] data = this.getData(String.format("%s/%s", this.brokersPath, broker));
        String jsonStr = Bytes.toString((byte[])data);
        Map brokerProps = (Map)JSON_SERDE.readValue(jsonStr, HashMap.class);
        String serverPort = (String)brokerProps.get("bootstrap.servers");
        if (serverPort != null) {
            bootstrapServers.append(',').append(serverPort);
        }
        if ((securityProtocol = (String)brokerProps.get("security.protocol")) != null) {
            this.connectionProperties.putIfAbsent("security.protocol", securityProtocol);
        }
        if ((saslMechanism = (String)brokerProps.get("sasl.mechanism")) != null) {
            this.connectionProperties.putIfAbsent("sasl.mechanism", saslMechanism);
        }
    }
}

