/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.listener;

import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.jni.NativeData;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.proto.Marlinserver;
import java.util.Optional;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.listener.MarlinListenerImpl;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.listener.NativeDataParser;
import org.apache.flink.kafka.shaded.com.mapr.kafka.eventstreams.impl.listener.NativeDataParserV10;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.NetworkException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinListenerImplV10
extends MarlinListenerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(MarlinListenerImplV10.class);

    @Override
    protected void checkConsumerConfig(ConsumerConfig config) throws KafkaException {
        super.checkConsumerConfig(config);
        Marlinserver.MarlinConfigDefaults mConfDef = Marlinserver.MarlinConfigDefaults.getDefaultInstance();
        try {
            Integer maxPollRecords = config.getInt(mConfDef.getMaxPollRecords());
            if (maxPollRecords < 1) {
                throw new ConfigException(mConfDef.getFetchMinBytes() + " Cannot be less than 1");
            }
        }
        catch (ConfigException e) {
            LOG.error(mConfDef.getFetchMinBytes() + " configuration");
            throw e;
        }
    }

    @Override
    protected void createJniListener(ConsumerConfig config, boolean hardMount, MapRUserInfo userInfo, Dbserver.CDCOpenFormatType cdcOFType) throws NetworkException {
        Marlinserver.MarlinConfigDefaults mConfDef = Marlinserver.MarlinConfigDefaults.getDefaultInstance();
        this._clntPtr = this.OpenListener(config.getString(mConfDef.getClientID()), Optional.ofNullable(config.getString(mConfDef.getGroupID())).orElse(""), this.rpcTimeoutMs, hardMount, config.getBoolean(mConfDef.getAutoCommitEnabled()), config.getInt(mConfDef.getAutoCommitInterval()).intValue(), this.autoCommitCbWrapper, config.getLong(mConfDef.getMetadataMaxAge()), config.getInt(mConfDef.getFetchMsgMaxBytesPerPartition()), config.getInt(mConfDef.getFetchMsgMaxBytes()), config.getInt(mConfDef.getFetchMinBytes()), config.getInt(mConfDef.getFetchMaxWaitMs()), config.getString(mConfDef.getAutoOffsetReset()), this.defaultStreamName, config.getLong(mConfDef.getConsumerBufferMemory()), config.getBoolean(mConfDef.getNegativeOffsetOnEof()), userInfo, cdcOFType.getNumber(), config.getInt(mConfDef.getMaxPollRecords()));
        if (this._clntPtr == 0L) {
            throw new NetworkException("Could not create Consumer. Please ensure that the CLDB service is configured properly and is available");
        }
    }

    public MarlinListenerImplV10(ConsumerConfig config, ConsumerInterceptors<?, ?> interceptors, Dbserver.CDCOpenFormatType cdcOFType) {
        super(config, interceptors, cdcOFType);
        LOG.debug("MarlinListenerImplV10 constructor");
    }

    public TimestampType convertMarlinTimestampTypeToKafka(int ttype) {
        Marlincommon.MarlinTimestampType implTtype = Marlincommon.MarlinTimestampType.valueOf((int)ttype);
        switch (implTtype) {
            case CreateTime: {
                return TimestampType.CREATE_TIME;
            }
            case LogAppendTime: {
                return TimestampType.LOG_APPEND_TIME;
            }
        }
        return TimestampType.NO_TIMESTAMP_TYPE;
    }

    @Override
    protected NativeDataParser getNativeDataParser(NativeData native_response) {
        return new NativeDataParserV10(native_response);
    }
}

