/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connector.kafka.lineage.DefaultKafkaDatasetIdentifier;
import org.apache.flink.connector.kafka.lineage.KafkaDatasetIdentifierProvider;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.connector.kafka.util.AdminUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.Admin;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionSetSubscriber
implements KafkaSubscriber,
KafkaDatasetIdentifierProvider {
    private static final long serialVersionUID = 390970375272146036L;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionSetSubscriber.class);
    private final Set<TopicPartition> subscribedPartitions;

    PartitionSetSubscriber(Set<TopicPartition> partitions) {
        this.subscribedPartitions = partitions;
    }

    @Override
    public Set<TopicPartition> getSubscribedTopicPartitions(AdminClient adminClient) {
        Set<String> topicNames = this.subscribedPartitions.stream().map(TopicPartition::topic).collect(Collectors.toSet());
        LOG.debug("Fetching descriptions for topics: {}", topicNames);
        Map<String, TopicDescription> topicMetadata = AdminUtils.getTopicMetadata((Admin)adminClient, topicNames);
        HashSet<TopicPartition> existingSubscribedPartitions = new HashSet<TopicPartition>();
        for (TopicPartition subscribedPartition : this.subscribedPartitions) {
            if (topicMetadata.containsKey(subscribedPartition.topic()) && this.partitionExistsInTopic(subscribedPartition, topicMetadata.get(subscribedPartition.topic()))) {
                existingSubscribedPartitions.add(subscribedPartition);
                continue;
            }
            throw new RuntimeException(String.format("Partition '%s' does not exist on Kafka brokers", subscribedPartition));
        }
        return existingSubscribedPartitions;
    }

    private boolean partitionExistsInTopic(TopicPartition partition, TopicDescription topic) {
        return topic.partitions().size() > partition.partition();
    }

    @Override
    public Optional<DefaultKafkaDatasetIdentifier> getDatasetIdentifier() {
        return Optional.of(DefaultKafkaDatasetIdentifier.ofTopics(this.subscribedPartitions.stream().map(TopicPartition::topic).distinct().collect(Collectors.toList())));
    }
}

