/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.enumerator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.dynamic.metadata.ClusterMetadata;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaStream;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.DynamicKafkaSourceEnumState;
import org.apache.flink.connector.kafka.source.enumerator.KafkaSourceEnumState;
import org.apache.flink.connector.kafka.source.enumerator.KafkaSourceEnumStateSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class DynamicKafkaSourceEnumStateSerializer
implements SimpleVersionedSerializer<DynamicKafkaSourceEnumState> {
    private static final int VERSION_1 = 1;
    private final KafkaSourceEnumStateSerializer kafkaSourceEnumStateSerializer = new KafkaSourceEnumStateSerializer();

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(DynamicKafkaSourceEnumState state) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                Set<KafkaStream> kafkaStreams = state.getKafkaStreams();
                this.serialize(kafkaStreams, out);
                Map<String, KafkaSourceEnumState> clusterEnumeratorStates = state.getClusterEnumeratorStates();
                out.writeInt(this.kafkaSourceEnumStateSerializer.getVersion());
                out.writeInt(clusterEnumeratorStates.size());
                for (Map.Entry<String, KafkaSourceEnumState> clusterEnumeratorState : clusterEnumeratorStates.entrySet()) {
                    String kafkaClusterId = clusterEnumeratorState.getKey();
                    out.writeUTF(kafkaClusterId);
                    byte[] bytes = this.kafkaSourceEnumStateSerializer.serialize(clusterEnumeratorState.getValue());
                    out.writeInt(bytes.length);
                    out.write(bytes);
                }
                object = baos.toByteArray();
            }
            return object;
        }
    }

    public DynamicKafkaSourceEnumState deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
                DynamicKafkaSourceEnumState dynamicKafkaSourceEnumState;
                try (DataInputStream in = new DataInputStream(bais);){
                    Set<KafkaStream> kafkaStreams = this.deserialize(in);
                    HashMap<String, KafkaSourceEnumState> clusterEnumeratorStates = new HashMap<String, KafkaSourceEnumState>();
                    int kafkaSourceEnumStateSerializerVersion = in.readInt();
                    int clusterEnumeratorStateMapSize = in.readInt();
                    for (int i = 0; i < clusterEnumeratorStateMapSize; ++i) {
                        String kafkaClusterId = in.readUTF();
                        int byteArraySize = in.readInt();
                        KafkaSourceEnumState kafkaSourceEnumState = this.kafkaSourceEnumStateSerializer.deserialize(kafkaSourceEnumStateSerializerVersion, DynamicKafkaSourceEnumStateSerializer.readNBytes(in, byteArraySize));
                        clusterEnumeratorStates.put(kafkaClusterId, kafkaSourceEnumState);
                    }
                    dynamicKafkaSourceEnumState = new DynamicKafkaSourceEnumState(kafkaStreams, clusterEnumeratorStates);
                }
                return dynamicKafkaSourceEnumState;
            }
        }
        throw new IOException(String.format("The bytes are serialized with version %d, while this deserializer only supports version up to %d", version, this.getVersion()));
    }

    private void serialize(Set<KafkaStream> kafkaStreams, DataOutputStream out) throws IOException {
        out.writeInt(kafkaStreams.size());
        for (KafkaStream kafkaStream : kafkaStreams) {
            out.writeUTF(kafkaStream.getStreamId());
            Map<String, ClusterMetadata> clusterMetadataMap = kafkaStream.getClusterMetadataMap();
            out.writeInt(clusterMetadataMap.size());
            for (Map.Entry<String, ClusterMetadata> entry : clusterMetadataMap.entrySet()) {
                String kafkaClusterId = entry.getKey();
                ClusterMetadata clusterMetadata = entry.getValue();
                out.writeUTF(kafkaClusterId);
                out.writeInt(clusterMetadata.getTopics().size());
                for (String topic : clusterMetadata.getTopics()) {
                    out.writeUTF(topic);
                }
                out.writeUTF((String)Preconditions.checkNotNull((Object)clusterMetadata.getProperties().getProperty("bootstrap.servers", "Bootstrap servers must be specified in properties")));
            }
        }
    }

    private Set<KafkaStream> deserialize(DataInputStream in) throws IOException {
        HashSet<KafkaStream> kafkaStreams = new HashSet<KafkaStream>();
        int numStreams = in.readInt();
        for (int i = 0; i < numStreams; ++i) {
            String streamId = in.readUTF();
            HashMap<String, ClusterMetadata> clusterMetadataMap = new HashMap<String, ClusterMetadata>();
            int clusterMetadataMapSize = in.readInt();
            for (int j = 0; j < clusterMetadataMapSize; ++j) {
                String kafkaClusterId = in.readUTF();
                int topicsSize = in.readInt();
                HashSet<String> topics = new HashSet<String>();
                for (int k = 0; k < topicsSize; ++k) {
                    topics.add(in.readUTF());
                }
                String bootstrapServers = in.readUTF();
                Properties properties = new Properties();
                properties.setProperty("bootstrap.servers", bootstrapServers);
                clusterMetadataMap.put(kafkaClusterId, new ClusterMetadata(topics, properties));
            }
            kafkaStreams.add(new KafkaStream(streamId, clusterMetadataMap));
        }
        return kafkaStreams;
    }

    private static byte[] readNBytes(DataInputStream in, int size) throws IOException {
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        return bytes;
    }
}

