/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static JcaTlsCertificate getEndEntity(JcaTlsCrypto crypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return JcaTlsCertificate.convert(crypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner signer;
        String algorithm = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(algorithm) || "RSASSA-PSS".equalsIgnoreCase(algorithm)) {
            PublicKey publicKey;
            int signatureScheme;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsRSAPSSSigner(crypto, privateKey, signatureScheme);
            }
            try {
                publicKey = JcaDefaultTlsCredentialedSigner.getEndEntity(crypto, certificate).getPubKeyRSA();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            signer = new JcaTlsRSASigner(crypto, privateKey, publicKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsDSASigner(crypto, privateKey);
        } else if (ECUtil.isECPrivateKey(privateKey)) {
            signer = new JcaTlsECDSASigner(crypto, privateKey);
        } else if ("Ed25519".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsEd25519Signer(crypto, privateKey);
        } else if ("Ed448".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsEd448Signer(crypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, JcaDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

