/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.customProperties;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.ArrayVisitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;

public class TitleSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    public TitleSchemaFactoryWrapper() {
        super(new TitleSchemaFactoryWrapperFactory());
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        ObjectVisitor visitor = (ObjectVisitor)super.expectObjectFormat(convertedType);
        this.addTitle(visitor.getSchema(), convertedType);
        return visitor;
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArrayVisitor visitor = (ArrayVisitor)super.expectArrayFormat(convertedType);
        this.addTitle(visitor.getSchema(), convertedType);
        return visitor;
    }

    private void addTitle(JsonSchema schema, JavaType type) {
        if (!schema.isSimpleTypeSchema()) {
            throw new RuntimeException("given non simple type schema: " + (Object)((Object)schema.getType()));
        }
        schema.asSimpleTypeSchema().setTitle(type.getGenericSignature());
    }

    private static class TitleSchemaFactoryWrapperFactory
    extends WrapperFactory {
        private TitleSchemaFactoryWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p) {
            TitleSchemaFactoryWrapper wrapper = new TitleSchemaFactoryWrapper();
            if (p != null) {
                wrapper.setProvider(p);
            }
            return wrapper;
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p, VisitorContext rvc) {
            TitleSchemaFactoryWrapper wrapper = new TitleSchemaFactoryWrapper();
            if (p != null) {
                wrapper.setProvider(p);
            }
            wrapper.setVisitorContext(rvc);
            return wrapper;
        }
    }
}

