/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.datafabric;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.util.DataFabricUtil;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTLSConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTLSConfigurer.class);
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String FILE_EXTENSION = "p12";
    private static final String KEYSTORES_DIRECTORY = ".dep-flink-keystores";
    private static final Set<PosixFilePermission> LOCAL_PERMISSIONS = PosixFilePermissions.fromString("rw-------");
    private final String username;
    private final FileSystem fs;
    private final org.apache.hadoop.conf.Configuration hadoopConfiguration;

    public static void apply(Configuration configuration) {
        new DefaultTLSConfigurer().applyInstance(configuration);
    }

    public DefaultTLSConfigurer() {
        try {
            this.username = UserGroupInformation.getCurrentUser().getShortUserName();
            this.hadoopConfiguration = new org.apache.hadoop.conf.Configuration();
            this.hadoopConfiguration.set("hadoop.security.credential.provider.path", String.format("jceks://maprfs@/user/%s/%s/passwords.jceks", this.username, KEYSTORES_DIRECTORY));
            this.fs = FileSystem.get((org.apache.hadoop.conf.Configuration)this.hadoopConfiguration);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize DefaultTLSConfigurer", e);
        }
    }

    public void applyInstance(Configuration configuration) {
        if (!DataFabricUtil.isDataFabricAvailable()) {
            LOG.info("Ignoring DefaultTLSConfigurer because of non-DataFabric environment");
            return;
        }
        try {
            this.maybeConfigureConnectivity(configuration, "internal");
            this.maybeConfigureConnectivity(configuration, "rest");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not apply DefaultTLSConfigurer", e);
        }
    }

    private void maybeConfigureConnectivity(Configuration configuration, String connectivity) throws IOException {
        boolean sslEnabled = "true".equals(configuration.getString(DefaultTLSConfigurer.option(connectivity, "enabled"), "true"));
        String keystorePath = configuration.getString(DefaultTLSConfigurer.option(connectivity, "keystore"), (String)configuration.get(SecurityOptions.SSL_KEYSTORE));
        if (!sslEnabled || keystorePath != null && new File(keystorePath).isFile()) {
            LOG.info("TLS is explicitly configured for {}, skipping DefaultTLSConfigurer", (Object)connectivity);
            return;
        }
        LOG.info("Configuring default keystores for {} connectivity", (Object)connectivity);
        this.configureKeystoreRole(configuration, connectivity, "keystore");
        this.configureKeystoreRole(configuration, connectivity, "truststore");
    }

    private void configureKeystoreRole(Configuration configuration, String connectivity, String keystoreRole) throws IOException {
        configuration.setString(DefaultTLSConfigurer.option(connectivity, keystoreRole), this.maybeDownloadKeystore(connectivity, keystoreRole));
        configuration.setString(DefaultTLSConfigurer.option(connectivity, keystoreRole + "-type"), KEYSTORE_TYPE);
        String passwordOption = DefaultTLSConfigurer.option(connectivity, keystoreRole + "-password");
        String password = new String(this.hadoopConfiguration.getPassword(passwordOption));
        configuration.setString(passwordOption, password);
        if ("keystore".equals(keystoreRole)) {
            configuration.setString(DefaultTLSConfigurer.option(connectivity, "key-password"), password);
        }
    }

    private String maybeDownloadKeystore(String connectivity, String keystoreRole) throws IOException {
        String localPath = String.format("%s/%s/%s-%s.%s", System.getProperty("user.home"), KEYSTORES_DIRECTORY, connectivity, keystoreRole, FILE_EXTENSION);
        if (Files.exists(Paths.get(localPath, new String[0]), new LinkOption[0])) {
            LOG.info("Found local default {} {} {}", new Object[]{connectivity, keystoreRole, localPath});
            return localPath;
        }
        Path maprfsPath = new Path(String.format("/user/%s/%s/%s-%s.%s", this.username, KEYSTORES_DIRECTORY, connectivity, keystoreRole, FILE_EXTENSION));
        LOG.info("Copying maprfs://{} to {}", (Object)maprfsPath, (Object)localPath);
        if (!this.fs.exists(maprfsPath)) {
            throw new IllegalStateException(String.format("Failed to apply DefaultTLSConfigurer for %s connectivity: %s does not exist", connectivity, maprfsPath));
        }
        this.fs.copyToLocalFile(maprfsPath, new Path(localPath));
        Files.setPosixFilePermissions(Paths.get(localPath, new String[0]), LOCAL_PERMISSIONS);
        return localPath;
    }

    private static String option(String connectivity, String suffix) {
        return String.format("security.ssl.%s.%s", connectivity, suffix);
    }
}

