/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.InputConsumableDecider;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;

public class PartialFinishedInputConsumableDecider
implements InputConsumableDecider {
    public static final int NUM_FINISHED_PARTITIONS_AS_CONSUMABLE = 1;

    @Override
    public boolean isInputConsumable(SchedulingExecutionVertex executionVertex, Set<ExecutionVertexID> verticesToDeploy, Map<ConsumedPartitionGroup, Boolean> consumableStatusCache) {
        for (ConsumedPartitionGroup consumedPartitionGroup : executionVertex.getConsumedPartitionGroups()) {
            if (consumableStatusCache.computeIfAbsent(consumedPartitionGroup, this::isConsumableBasedOnFinishedProducers).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConsumableBasedOnFinishedProducers(ConsumedPartitionGroup consumedPartitionGroup) {
        if (consumedPartitionGroup.getResultPartitionType().isBlockingOrBlockingPersistentResultPartition()) {
            return consumedPartitionGroup.getNumberOfUnfinishedPartitions() == 0;
        }
        int numFinishedPartitions = consumedPartitionGroup.size() - consumedPartitionGroup.getNumberOfUnfinishedPartitions();
        return numFinishedPartitions >= 1;
    }

    public static class Factory
    implements InputConsumableDecider.Factory {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public InputConsumableDecider createInstance(SchedulingTopology schedulingTopology, Function<ExecutionVertexID, Boolean> scheduledVertexRetriever, Function<ExecutionVertexID, ExecutionState> executionStateRetriever) {
            return new PartialFinishedInputConsumableDecider();
        }
    }
}

