/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.ResourceListener;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitionManager;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.scheduler.adaptive.StateWithoutExecutionGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class WaitingForResources
extends StateWithoutExecutionGraph
implements ResourceListener,
StateTransitionManager.Context {
    private final Context context;
    @Nullable
    private ScheduledFuture<?> resourceTimeoutFuture;
    @Nullable
    private final ExecutionGraph previousExecutionGraph;
    private final StateTransitionManager stateTransitionManager;

    @VisibleForTesting
    WaitingForResources(Context context, Logger log, Duration submissionResourceWaitTimeout, Function<StateTransitionManager.Context, StateTransitionManager> stateTransitionManagerFactory) {
        this(context, log, submissionResourceWaitTimeout, null, stateTransitionManagerFactory);
    }

    WaitingForResources(Context context, Logger log, Duration submissionResourceWaitTimeout, @Nullable ExecutionGraph previousExecutionGraph, Function<StateTransitionManager.Context, StateTransitionManager> stateTransitionManagerFactory) {
        super(context, log);
        this.context = (Context)Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)submissionResourceWaitTimeout);
        this.stateTransitionManager = stateTransitionManagerFactory.apply(this);
        if (!submissionResourceWaitTimeout.isNegative()) {
            this.resourceTimeoutFuture = context.runIfState(this, this::resourceTimeout, submissionResourceWaitTimeout);
        }
        this.previousExecutionGraph = previousExecutionGraph;
        context.runIfState(this, this::checkPotentialStateTransition, Duration.ZERO);
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        if (this.resourceTimeoutFuture != null) {
            this.resourceTimeoutFuture.cancel(false);
        }
        this.stateTransitionManager.close();
        super.onLeave(newState);
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.CREATED;
    }

    @Override
    public void onNewResourcesAvailable() {
        this.checkPotentialStateTransition();
    }

    @Override
    public void onNewResourceRequirements() {
        this.checkPotentialStateTransition();
    }

    private void checkPotentialStateTransition() {
        this.stateTransitionManager.onChange();
        this.stateTransitionManager.onTrigger();
    }

    private void resourceTimeout() {
        this.getLogger().debug("Initial resource allocation timeout triggered: Creating ExecutionGraph with available resources.");
        this.transitionToSubsequentState();
    }

    @Override
    public boolean hasSufficientResources() {
        return this.context.hasSufficientResources();
    }

    @Override
    public boolean hasDesiredResources() {
        return this.context.hasDesiredResources();
    }

    @Override
    public void transitionToSubsequentState() {
        this.context.goToCreatingExecutionGraph(this.previousExecutionGraph);
    }

    @Override
    public ScheduledFuture<?> scheduleOperation(Runnable callback, Duration delay) {
        return this.context.runIfState(this, callback, delay);
    }

    static interface Context
    extends StateWithoutExecutionGraph.Context,
    StateTransitions.ToCreatingExecutionGraph {
        public boolean hasDesiredResources();

        public boolean hasSufficientResources();

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }

    static class Factory
    implements StateFactory<WaitingForResources> {
        private final Context context;
        private final Logger log;
        private final Duration submissionResourceWaitTimeout;
        @Nullable
        private final ExecutionGraph previousExecutionGraph;
        private final Function<StateTransitionManager.Context, StateTransitionManager> stateTransitionManagerFactory;

        public Factory(Context context, Logger log, Duration submissionResourceWaitTimeout, Function<StateTransitionManager.Context, StateTransitionManager> stateTransitionManagerFactory, @Nullable ExecutionGraph previousExecutionGraph) {
            this.context = context;
            this.log = log;
            this.submissionResourceWaitTimeout = submissionResourceWaitTimeout;
            this.previousExecutionGraph = previousExecutionGraph;
            this.stateTransitionManagerFactory = stateTransitionManagerFactory;
        }

        @Override
        public Class<WaitingForResources> getStateClass() {
            return WaitingForResources.class;
        }

        @Override
        public WaitingForResources getState() {
            return new WaitingForResources(this.context, this.log, this.submissionResourceWaitTimeout, this.previousExecutionGraph, this.stateTransitionManagerFactory);
        }
    }
}

