/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.runtime.client.JobCancellationException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.SerializedValue;

public class JobResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobId;
    private final ApplicationStatus applicationStatus;
    private final Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults;
    private final long netRuntime;
    @Nullable
    private final SerializedThrowable serializedThrowable;

    private JobResult(JobID jobId, ApplicationStatus applicationStatus, Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults, long netRuntime, @Nullable SerializedThrowable serializedThrowable) {
        Preconditions.checkArgument((netRuntime >= 0L ? 1 : 0) != 0, (Object)"netRuntime must be greater than or equals 0");
        this.jobId = Objects.requireNonNull(jobId);
        this.applicationStatus = Objects.requireNonNull(applicationStatus);
        this.accumulatorResults = Objects.requireNonNull(accumulatorResults);
        this.netRuntime = netRuntime;
        this.serializedThrowable = serializedThrowable;
    }

    public boolean isSuccess() {
        return this.applicationStatus == ApplicationStatus.SUCCEEDED || this.applicationStatus == ApplicationStatus.UNKNOWN && this.serializedThrowable == null;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ApplicationStatus getApplicationStatus() {
        return this.applicationStatus;
    }

    public Map<String, SerializedValue<OptionalFailure<Object>>> getAccumulatorResults() {
        return this.accumulatorResults;
    }

    public long getNetRuntime() {
        return this.netRuntime;
    }

    public Optional<SerializedThrowable> getSerializedThrowable() {
        return Optional.ofNullable(this.serializedThrowable);
    }

    public JobExecutionResult toJobExecutionResult(ClassLoader classLoader) throws JobExecutionException, IOException, ClassNotFoundException {
        if (this.applicationStatus == ApplicationStatus.SUCCEEDED) {
            return new JobExecutionResult(this.jobId, this.netRuntime, AccumulatorHelper.deserializeAccumulators(this.accumulatorResults, (ClassLoader)classLoader));
        }
        Throwable cause = this.serializedThrowable == null ? null : this.serializedThrowable.deserializeError(classLoader);
        JobExecutionException exception = this.applicationStatus == ApplicationStatus.FAILED ? new JobExecutionException(this.jobId, "Job execution failed.", cause) : (this.applicationStatus == ApplicationStatus.CANCELED ? new JobCancellationException(this.jobId, "Job was cancelled.", cause) : new JobExecutionException(this.jobId, "Job completed with illegal application status: " + this.applicationStatus + ".", cause));
        throw exception;
    }

    public static JobResult createFrom(AccessExecutionGraph accessExecutionGraph) {
        JobID jobId = accessExecutionGraph.getJobID();
        JobStatus jobStatus = accessExecutionGraph.getState();
        Preconditions.checkArgument((boolean)jobStatus.isTerminalState(), (Object)("The job " + accessExecutionGraph.getJobName() + "(" + jobId + ") is not in a terminal state. It is in state " + jobStatus + "."));
        Builder builder = new Builder();
        builder.jobId(jobId);
        builder.applicationStatus(ApplicationStatus.fromJobStatus(accessExecutionGraph.getState()));
        long netRuntime = accessExecutionGraph.getStatusTimestamp(jobStatus) - accessExecutionGraph.getStatusTimestamp(JobStatus.INITIALIZING);
        long guardedNetRuntime = Math.max(netRuntime, 0L);
        builder.netRuntime(guardedNetRuntime);
        builder.accumulatorResults(accessExecutionGraph.getAccumulatorsSerialized());
        if (jobStatus == JobStatus.FAILED) {
            ErrorInfo errorInfo = accessExecutionGraph.getFailureInfo();
            Preconditions.checkNotNull((Object)errorInfo, (String)"No root cause is found for the job failure.");
            builder.serializedThrowable(errorInfo.getException());
        }
        return builder.build();
    }

    @Internal
    public static class Builder {
        private JobID jobId;
        private ApplicationStatus applicationStatus = ApplicationStatus.UNKNOWN;
        private Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults;
        private long netRuntime = -1L;
        private SerializedThrowable serializedThrowable;

        public Builder jobId(JobID jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        public Builder accumulatorResults(Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults) {
            this.accumulatorResults = accumulatorResults;
            return this;
        }

        public Builder netRuntime(long netRuntime) {
            this.netRuntime = netRuntime;
            return this;
        }

        public Builder serializedThrowable(SerializedThrowable serializedThrowable) {
            this.serializedThrowable = serializedThrowable;
            return this;
        }

        public JobResult build() {
            return new JobResult(this.jobId, this.applicationStatus, this.accumulatorResults == null ? Collections.emptyMap() : this.accumulatorResults, this.netRuntime, this.serializedThrowable);
        }
    }
}

