/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.runtime.asyncprocessing.EpochManager;
import org.apache.flink.runtime.asyncprocessing.ReferenceCounted;
import org.apache.flink.runtime.state.v2.internal.InternalPartitionedState;

public class RecordContext<K>
extends ReferenceCounted<DisposerRunner> {
    static final Object EMPTY_RECORD = new Object();
    static final int PRIORITY_MIN = 0;
    private final Object record;
    private final K key;
    private volatile boolean keyOccupied;
    private final Consumer<RecordContext<K>> disposer;
    private final int keyGroup;
    private Map<InternalPartitionedState<?>, Object> namespaces = null;
    private final AtomicReferenceArray<Object> contextVariables;
    @Nullable
    private volatile Object extra;
    private final EpochManager.Epoch epoch;
    private final int priority;

    public RecordContext(Object record, K key, Consumer<RecordContext<K>> disposer, int keyGroup, EpochManager.Epoch epoch, int variableCount) {
        this(record, key, disposer, keyGroup, epoch, new AtomicReferenceArray<Object>(variableCount), 0);
    }

    public RecordContext(Object record, K key, Consumer<RecordContext<K>> disposer, int keyGroup, EpochManager.Epoch epoch, int variableCount, int priority) {
        this(record, key, disposer, keyGroup, epoch, new AtomicReferenceArray<Object>(variableCount), priority);
    }

    public RecordContext(Object record, K key, Consumer<RecordContext<K>> disposer, int keyGroup, EpochManager.Epoch epoch, AtomicReferenceArray<Object> variables, int priority) {
        super(0);
        this.record = record;
        this.key = key;
        this.keyOccupied = false;
        this.disposer = disposer;
        this.keyGroup = keyGroup;
        this.epoch = epoch;
        this.contextVariables = variables;
        this.priority = priority;
    }

    public Object getRecord() {
        return this.record;
    }

    public K getKey() {
        return this.key;
    }

    boolean isKeyOccupied() {
        return this.keyOccupied;
    }

    void setKeyOccupied() {
        this.keyOccupied = true;
    }

    @Override
    protected void referenceCountReachedZero(@Nullable DisposerRunner disposerRunner) {
        if (this.keyOccupied) {
            this.keyOccupied = false;
            if (disposerRunner != null) {
                disposerRunner.runDisposer(() -> this.disposer.accept(this));
            } else {
                this.disposer.accept(this);
            }
        }
    }

    public int getKeyGroup() {
        return this.keyGroup;
    }

    public <N> N getNamespace(InternalPartitionedState<N> state) {
        return (N)(this.namespaces == null ? null : this.namespaces.get(state));
    }

    public <N> void setNamespace(InternalPartitionedState<N> state, N namespace) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        this.namespaces.put(state, namespace);
    }

    public <T> T getVariable(int i) {
        this.checkVariableIndex(i);
        return (T)this.contextVariables.get(i);
    }

    public <T> void setVariable(int i, T value) {
        this.checkVariableIndex(i);
        this.contextVariables.set(i, value);
    }

    private void checkVariableIndex(int i) {
        if (i >= this.contextVariables.length()) {
            throw new UnsupportedOperationException("Variable index out of bounds. Maybe you are accessing a variable that have not been declared.");
        }
    }

    AtomicReferenceArray<Object> getVariablesReference() {
        return this.contextVariables;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public Object getExtra() {
        return this.extra;
    }

    public EpochManager.Epoch getEpoch() {
        return this.epoch;
    }

    public int getPriority() {
        return this.priority;
    }

    public int hashCode() {
        return Objects.hash(this.record, this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordContext that = (RecordContext)o;
        if (!Objects.equals(this.record, that.record)) {
            return false;
        }
        if (!Objects.equals(this.keyGroup, that.keyGroup)) {
            return false;
        }
        if (!Objects.equals(this.epoch, that.epoch)) {
            return false;
        }
        return Objects.equals(this.key, that.key);
    }

    public String toString() {
        return "RecordContext{record=" + this.record + ", key=" + this.key + ", occupied=" + this.keyOccupied + ", ref=" + this.getReferenceCount() + ", epoch=" + this.epoch.id + ", priority=" + this.priority + "}";
    }

    public static interface DisposerRunner {
        public void runDisposer(Runnable var1);
    }
}

