/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.triggers.CountTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CountTriggerTest {
    CountTriggerTest() {
    }

    @Test
    void testWindowSeparationAndFiring() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(CountTrigger.of((long)3L), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isOne();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isOne();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
    }

    @Test
    void testClear() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(CountTrigger.of((long)3L), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isOne();
        testHarness.clearTriggerState(new TimeWindow(2L, 4L));
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isZero();
        testHarness.clearTriggerState(new TimeWindow(0L, 2L));
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isZero();
    }

    @Test
    void testMergingWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(CountTrigger.of((long)3L), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(4L, 6L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(3);
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(4L, 6L))).isOne();
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 4L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(4L, 6L))).isOne();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 4L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 4L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(4L, 6L))).isOne();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(4L, 6L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(4L, 6L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
    }

    @Test
    void testMergeSubsumingWindow() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(CountTrigger.of((long)3L), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(4L, 6L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(4L, 6L))).isOne();
        testHarness.mergeWindows(new TimeWindow(0L, 8L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(2L, 4L), new TimeWindow(4L, 6L)}));
        Assertions.assertThat((int)testHarness.numStateEntries()).isOne();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(2L, 4L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(4L, 6L))).isZero();
        Assertions.assertThat((int)testHarness.numStateEntries(new TimeWindow(0L, 8L))).isOne();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 8L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
    }
}

