/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.AbstractBroadcastStateTransformation;
import org.apache.flink.streaming.api.transformations.AbstractMultipleInputTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class GetTransitivePredecessorsTest {
    private TestTransformation<Integer> commonNode;
    private Transformation<Integer> midNode;

    GetTransitivePredecessorsTest() {
    }

    @BeforeEach
    void setup() {
        this.commonNode = new TestTransformation("commonNode", new MockIntegerTypeInfo(), 1);
        this.midNode = new OneInputTransformation(this.commonNode, "midNode", (OneInputStreamOperator)new DummyOneInputOperator(), (TypeInformation)new MockIntegerTypeInfo(), 1);
    }

    @Test
    void testTwoInputTransformation() {
        TwoInputTransformation topNode = new TwoInputTransformation(this.commonNode, this.midNode, "topNode", new DummyTwoInputOperator(), this.midNode.getOutputType(), 1);
        List predecessors = topNode.getTransitivePredecessors();
        Assertions.assertThat((int)predecessors.size()).isEqualTo(3);
        Assertions.assertThat((int)this.commonNode.getNumGetTransitivePredecessor()).isEqualTo(1);
    }

    @Test
    void testUnionTransformation() {
        UnionTransformation topNode = new UnionTransformation(Arrays.asList(new Transformation[]{this.commonNode, this.midNode}));
        List predecessors = topNode.getTransitivePredecessors();
        Assertions.assertThat((int)predecessors.size()).isEqualTo(3);
        Assertions.assertThat((int)this.commonNode.getNumGetTransitivePredecessor()).isEqualTo(1);
    }

    @Test
    void testBroadcastStateTransformation() {
        AbstractBroadcastStateTransformation topNode = new AbstractBroadcastStateTransformation("topNode", this.commonNode, this.midNode, null, this.midNode.getOutputType(), 1);
        List predecessors = topNode.getTransitivePredecessors();
        Assertions.assertThat((int)predecessors.size()).isEqualTo(3);
        Assertions.assertThat((int)this.commonNode.getNumGetTransitivePredecessor()).isEqualTo(0);
    }

    @Test
    void testAbstractMultipleInputTransformation() {
        AbstractMultipleInputTransformation<Integer> topNode = new AbstractMultipleInputTransformation<Integer>("topNode", (StreamOperatorFactory)SimpleOperatorFactory.of(new DummyTwoInputOperator()), this.midNode.getOutputType(), 1){

            public List<Transformation<?>> getInputs() {
                return Arrays.asList(new Transformation[]{GetTransitivePredecessorsTest.this.commonNode, GetTransitivePredecessorsTest.this.midNode});
            }
        };
        List predecessors = topNode.getTransitivePredecessors();
        Assertions.assertThat((int)predecessors.size()).isEqualTo(3);
        Assertions.assertThat((int)this.commonNode.getNumGetTransitivePredecessor()).isEqualTo(1);
    }

    private static class TestTransformation<T>
    extends Transformation<T> {
        private int numGetTransitivePredecessor = 0;

        public TestTransformation(String name, TypeInformation<T> outputType, int parallelism) {
            super(name, outputType, parallelism);
        }

        protected List<Transformation<?>> getTransitivePredecessorsInternal() {
            ++this.numGetTransitivePredecessor;
            return Collections.singletonList(this);
        }

        public List<Transformation<?>> getInputs() {
            return Collections.emptyList();
        }

        public int getNumGetTransitivePredecessor() {
            return this.numGetTransitivePredecessor;
        }
    }

    private static class MockIntegerTypeInfo
    extends GenericTypeInfo<Integer> {
        public MockIntegerTypeInfo() {
            super(Integer.class);
        }
    }

    private static class DummyOneInputOperator
    extends AbstractStreamOperator<Integer>
    implements OneInputStreamOperator<Integer, Integer> {
        private DummyOneInputOperator() {
        }

        public void processElement(StreamRecord<Integer> element) throws Exception {
        }
    }

    private static class DummyTwoInputOperator<T>
    extends AbstractStreamOperator<T>
    implements TwoInputStreamOperator<T, T, T> {
        private DummyTwoInputOperator() {
        }

        public void processElement1(StreamRecord<T> element) throws Exception {
            this.output.collect(element);
        }

        public void processElement2(StreamRecord<T> element) throws Exception {
            this.output.collect(element);
        }
    }
}

