/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamSinkOperatorTest {
    StreamSinkOperatorTest() {
    }

    @Test
    void testTimeQuerying() throws Exception {
        BufferingQueryingSink bufferingSink = new BufferingQueryingSink();
        StreamSink operator = new StreamSink(bufferingSink);
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        testHarness.setup();
        testHarness.open();
        testHarness.processWatermark(new Watermark(17L));
        testHarness.setProcessingTime(12L);
        testHarness.processElement(new StreamRecord((Object)"Hello", 12L));
        testHarness.processWatermark(new Watermark(42L));
        testHarness.setProcessingTime(15L);
        testHarness.processElement(new StreamRecord((Object)"Ciao", 13L));
        testHarness.processWatermark(new Watermark(42L));
        testHarness.setProcessingTime(15L);
        testHarness.processElement(new StreamRecord((Object)"Ciao"));
        Assertions.assertThat(bufferingSink.data).hasSize(3);
        Assertions.assertThat(bufferingSink.data).contains((Object[])new Tuple4[]{new Tuple4((Object)17L, (Object)12L, (Object)12L, (Object)"Hello"), new Tuple4((Object)42L, (Object)15L, (Object)13L, (Object)"Ciao"), new Tuple4((Object)42L, (Object)15L, null, (Object)"Ciao")});
        Assertions.assertThat(bufferingSink.watermarks).hasSize(3);
        Assertions.assertThat(bufferingSink.watermarks).contains((Object[])new org.apache.flink.api.common.eventtime.Watermark[]{new org.apache.flink.api.common.eventtime.Watermark(17L), new org.apache.flink.api.common.eventtime.Watermark(42L), new org.apache.flink.api.common.eventtime.Watermark(42L)});
        testHarness.close();
    }

    private static class BufferingQueryingSink<T>
    implements SinkFunction<T> {
        private final List<Tuple4<Long, Long, Long, T>> data = new ArrayList<Tuple4<Long, Long, Long, T>>();
        private final List<org.apache.flink.api.common.eventtime.Watermark> watermarks = new ArrayList<org.apache.flink.api.common.eventtime.Watermark>();

        public void invoke(T value, SinkFunction.Context context) throws Exception {
            Long timestamp = context.timestamp();
            if (timestamp != null) {
                this.data.add(new Tuple4((Object)context.currentWatermark(), (Object)context.currentProcessingTime(), (Object)context.timestamp(), value));
            } else {
                this.data.add(new Tuple4((Object)context.currentWatermark(), (Object)context.currentProcessingTime(), null, value));
            }
        }

        public void writeWatermark(org.apache.flink.api.common.eventtime.Watermark watermark) throws Exception {
            this.watermarks.add(watermark);
        }
    }
}

