/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.FlinkSecurityManager;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FlinkSecurityManagerITCase {
    FlinkSecurityManagerITCase() {
    }

    @BeforeEach
    void ensureSupportedOS() {
        Assumptions.assumeThat((OperatingSystem.isLinux() || OperatingSystem.isMac() ? 1 : 0) != 0).isTrue();
    }

    @Test
    void testForcedJVMExit() throws Exception {
        ForcedJVMExitProcess testProcess = new ForcedJVMExitProcess(ForcedExitEntryPoint.class);
        testProcess.startProcess();
        try {
            testProcess.waitFor();
            Assertions.assertThat((int)testProcess.exitCode()).isEqualTo(222);
        }
        finally {
            testProcess.destroy();
        }
    }

    @Test
    void testIgnoredJVMExit() throws Exception {
        ForcedJVMExitProcess testProcess = new ForcedJVMExitProcess(IgnoredExitEntryPoint.class);
        testProcess.startProcess();
        try {
            testProcess.waitFor();
            Assertions.assertThat((int)testProcess.exitCode()).isZero();
        }
        finally {
            testProcess.destroy();
        }
    }

    private static final class ForcedJVMExitProcess
    extends TestJvmProcess {
        private final Class<?> entryPointName;

        private ForcedJVMExitProcess(Class<?> entryPointName) throws Exception {
            this.entryPointName = entryPointName;
        }

        @Override
        public String getName() {
            return this.getEntryPointClassName();
        }

        @Override
        public String[] getMainMethodArgs() {
            return new String[0];
        }

        @Override
        public String getEntryPointClassName() {
            return this.entryPointName.getName();
        }
    }

    public static final class ForcedExitEntryPoint {
        public static void main(String[] args) throws Exception {
            Configuration configuration = new Configuration();
            configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
            FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
            FlinkSecurityManager.forceProcessExit((int)222);
            System.exit(0);
        }
    }

    public static final class IgnoredExitEntryPoint {
        public static void main(String[] args) throws Exception {
            Configuration configuration = new Configuration();
            configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
            FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
            FlinkSecurityManager.monitorUserSystemExitForCurrentThread();
            try {
                System.exit(123);
            }
            catch (Throwable t) {
                System.err.println("Caught exception during system exit with message: " + t.getMessage());
            }
        }
    }
}

