/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskexecutor.slot.DefaultTimerService;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTableImpl;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;

public final class TaskSlotUtils
extends Enum<TaskSlotUtils> {
    private static final long DEFAULT_SLOT_TIMEOUT = 10000L;
    public static final ResourceProfile DEFAULT_RESOURCE_PROFILE;
    private static final /* synthetic */ TaskSlotUtils[] $VALUES;

    public static TaskSlotUtils[] values() {
        return (TaskSlotUtils[])$VALUES.clone();
    }

    public static TaskSlotUtils valueOf(String name) {
        return Enum.valueOf(TaskSlotUtils.class, name);
    }

    public static <T extends TaskSlotPayload> TaskSlotTableImpl<T> createTaskSlotTable(int numberOfSlots, ScheduledExecutorService executorService) {
        return TaskSlotUtils.createTaskSlotTable(numberOfSlots, TaskSlotUtils.createDefaultTimerService(10000L), executorService);
    }

    public static <T extends TaskSlotPayload> TaskSlotTable<T> createTaskSlotTable(int numberOfSlots, Duration timeout, ScheduledExecutorService executorService) {
        return TaskSlotUtils.createTaskSlotTable(numberOfSlots, TaskSlotUtils.createDefaultTimerService(timeout.toMillis()), executorService);
    }

    public static <T extends TaskSlotPayload> TaskSlotTableImpl<T> createTaskSlotTable(int numberOfSlots, TimerService<AllocationID> timerService, ScheduledExecutorService executorService) {
        return new TaskSlotTableImpl(numberOfSlots, TaskSlotUtils.createTotalResourceProfile(numberOfSlots), DEFAULT_RESOURCE_PROFILE, 4096, timerService, (Executor)executorService);
    }

    public static ResourceProfile createTotalResourceProfile(int numberOfSlots) {
        ResourceProfile result = DEFAULT_RESOURCE_PROFILE;
        for (int i = 0; i < numberOfSlots - 1; ++i) {
            result = result.merge(DEFAULT_RESOURCE_PROFILE);
        }
        return result;
    }

    public static TimerService<AllocationID> createDefaultTimerService(long shutdownTimeout) {
        return new DefaultTimerService(Executors.newSingleThreadScheduledExecutor(), shutdownTimeout);
    }

    private static /* synthetic */ TaskSlotUtils[] $values() {
        return new TaskSlotUtils[0];
    }

    static {
        $VALUES = TaskSlotUtils.$values();
        DEFAULT_RESOURCE_PROFILE = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemory(new MemorySize(102400L)).setTaskOffHeapMemory(MemorySize.ZERO).setManagedMemory(new MemorySize(40960L)).setNetworkMemory(new MemorySize(102400L)).build();
    }
}

