/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.HashMap;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.AbstractKeyedStateTestBase;
import org.apache.flink.runtime.state.v2.AbstractMapState;
import org.junit.jupiter.api.Test;

public class AbstractMapStateTest
extends AbstractKeyedStateTestBase {
    @Test
    public void testEachOperation() {
        MapStateDescriptor descriptor = new MapStateDescriptor("testState", (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        AbstractMapState mapState = new AbstractMapState((StateRequestHandler)this.aec, descriptor);
        this.aec.setCurrentContext(this.aec.buildContext((Object)"test", (Object)"test"));
        mapState.asyncClear();
        this.validateRequestRun((State)mapState, StateRequestType.CLEAR, null, 0);
        mapState.asyncGet((Object)"key1");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_GET, "key1", 0);
        mapState.asyncPut((Object)"key2", (Object)2);
        this.validateRequestRun((State)mapState, StateRequestType.MAP_PUT, Tuple2.of((Object)"key2", (Object)2), 0);
        HashMap map = new HashMap();
        mapState.asyncPutAll(map);
        this.validateRequestRun((State)mapState, StateRequestType.MAP_PUT_ALL, map, 0);
        mapState.asyncRemove((Object)"key3");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_REMOVE, "key3", 0);
        mapState.asyncContains((Object)"key4");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_CONTAINS, "key4", 0);
        mapState.asyncEntries();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER, null, 0);
        mapState.asyncKeys();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER_KEY, null, 0);
        mapState.asyncValues();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER_VALUE, null, 0);
        mapState.asyncIsEmpty();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_IS_EMPTY, null, 0);
        mapState.clear();
        this.validateRequestRun((State)mapState, StateRequestType.CLEAR, null, 0);
        mapState.get((Object)"key1");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_GET, "key1", 0);
        mapState.put((Object)"key2", (Object)2);
        this.validateRequestRun((State)mapState, StateRequestType.MAP_PUT, Tuple2.of((Object)"key2", (Object)2), 0);
        mapState.putAll(map);
        this.validateRequestRun((State)mapState, StateRequestType.MAP_PUT_ALL, map, 0);
        mapState.remove((Object)"key3");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_REMOVE, "key3", 0);
        mapState.contains((Object)"key4");
        this.validateRequestRun((State)mapState, StateRequestType.MAP_CONTAINS, "key4", 0);
        mapState.iterator();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER, null, 0);
        mapState.entries().iterator();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER, null, 0);
        mapState.keys().iterator();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER_KEY, null, 0);
        mapState.values().iterator();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_ITER_VALUE, null, 0);
        mapState.isEmpty();
        this.validateRequestRun((State)mapState, StateRequestType.MAP_IS_EMPTY, null, 0);
    }
}

