/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializer;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TtlAwareSerializerTest {
    TtlAwareSerializerTest() {
    }

    @Test
    void testSerializerTtlEnabled() {
        IntSerializer intSerializer = IntSerializer.INSTANCE;
        ListSerializer listSerializer = new ListSerializer((TypeSerializer)intSerializer);
        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)intSerializer, (TypeSerializer)intSerializer);
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)intSerializer)).isFalse();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)listSerializer)).isFalse();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)mapSerializer)).isFalse();
        TtlStateFactory.TtlSerializer intTtlSerializer = new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)intSerializer);
        ListSerializer listTtlSerializer = new ListSerializer((TypeSerializer)intTtlSerializer);
        MapSerializer mapTtlSerializer = new MapSerializer((TypeSerializer)intSerializer, (TypeSerializer)intTtlSerializer);
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)intTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)listTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)mapTtlSerializer)).isTrue();
    }

    @Test
    void testWrapTypeSerializer() {
        IntSerializer intSerializer = IntSerializer.INSTANCE;
        ListSerializer listSerializer = new ListSerializer((TypeSerializer)intSerializer);
        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)intSerializer, (TypeSerializer)intSerializer);
        TypeSerializer intTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)intSerializer);
        ListSerializer listTtlAwareSerializer = (ListSerializer)TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)listSerializer);
        MapSerializer mapTtlAwareSerializer = (MapSerializer)TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)mapSerializer);
        Assertions.assertThat((Object)intTtlAwareSerializer).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((boolean)((TtlAwareSerializer)intTtlAwareSerializer).isTtlEnabled()).isFalse();
        Assertions.assertThat((Object)listTtlAwareSerializer.getElementSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((boolean)((TtlAwareSerializer)listTtlAwareSerializer.getElementSerializer()).isTtlEnabled()).isFalse();
        Assertions.assertThat((Object)mapTtlAwareSerializer.getValueSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((boolean)((TtlAwareSerializer)mapTtlAwareSerializer.getValueSerializer()).isTtlEnabled()).isFalse();
    }

    @Test
    void testWrapTtlSerializer() {
        TtlStateFactory.TtlSerializer intTtlSerializer = new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        ListSerializer listTtlSerializer = new ListSerializer((TypeSerializer)intTtlSerializer);
        MapSerializer mapTtlSerializer = new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)intTtlSerializer);
        TypeSerializer intTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)intTtlSerializer);
        ListSerializer listTtlAwareSerializer = (ListSerializer)TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)listTtlSerializer);
        MapSerializer mapTtlAwareSerializer = (MapSerializer)TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)mapTtlSerializer);
        Assertions.assertThat((Object)intTtlAwareSerializer).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((boolean)((TtlAwareSerializer)intTtlAwareSerializer).isTtlEnabled()).isTrue();
        Assertions.assertThat((Object)listTtlAwareSerializer.getElementSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((boolean)((TtlAwareSerializer)listTtlAwareSerializer.getElementSerializer()).isTtlEnabled()).isTrue();
        Assertions.assertThat((Object)mapTtlAwareSerializer.getValueSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((boolean)((TtlAwareSerializer)mapTtlAwareSerializer.getValueSerializer()).isTtlEnabled()).isTrue();
    }
}

