/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.runtime.state.InternalPriorityQueueTestBase;
import org.apache.flink.runtime.state.heap.HeapPriorityQueue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HeapPriorityQueueTest
extends InternalPriorityQueueTestBase {
    HeapPriorityQueueTest() {
    }

    @Test
    void testClear() {
        HeapPriorityQueue<InternalPriorityQueueTestBase.TestElement> priorityQueueSet = this.newPriorityQueue(1);
        int count = 10;
        HashSet<InternalPriorityQueueTestBase.TestElement> checkSet = new HashSet<InternalPriorityQueueTestBase.TestElement>(count);
        HeapPriorityQueueTest.insertRandomElements(priorityQueueSet, checkSet, count);
        Assertions.assertThat((int)priorityQueueSet.size()).isEqualTo(count);
        priorityQueueSet.clear();
        Assertions.assertThat((int)priorityQueueSet.size()).isZero();
    }

    @Test
    void testToArray() {
        int testSize = 10;
        ArrayList<InternalPriorityQueueTestBase.TestElement[]> tests = new ArrayList<InternalPriorityQueueTestBase.TestElement[]>(2);
        tests.add(new InternalPriorityQueueTestBase.TestElement[0]);
        tests.add(new InternalPriorityQueueTestBase.TestElement[10]);
        tests.add(new InternalPriorityQueueTestBase.TestElement[11]);
        for (InternalPriorityQueueTestBase.TestElement[] testArray : tests) {
            Arrays.fill((Object[])testArray, (Object)new InternalPriorityQueueTestBase.TestElement(42L, 4711L));
            HashSet<InternalPriorityQueueTestBase.TestElement> checkSet = new HashSet<InternalPriorityQueueTestBase.TestElement>(10);
            HeapPriorityQueue<InternalPriorityQueueTestBase.TestElement> timerPriorityQueue = this.newPriorityQueue(1);
            Assertions.assertThat((Object[])testArray).hasSameSizeAs((Object)timerPriorityQueue.toArray((Object[])testArray));
            HeapPriorityQueueTest.insertRandomElements(timerPriorityQueue, checkSet, 10);
            InternalPriorityQueueTestBase.TestElement[] toArray = (InternalPriorityQueueTestBase.TestElement[])timerPriorityQueue.toArray((Object[])testArray);
            Assertions.assertThat((testArray.length >= 10 ? 1 : 0) != 0).isEqualTo(testArray == toArray);
            int count = 0;
            for (InternalPriorityQueueTestBase.TestElement o : toArray) {
                if (o == null) break;
                Assertions.assertThat((boolean)checkSet.remove((Object)o)).isTrue();
                ++count;
            }
            Assertions.assertThat((int)timerPriorityQueue.size()).isEqualTo(count);
            Assertions.assertThat(checkSet).isEmpty();
        }
    }

    protected HeapPriorityQueue<InternalPriorityQueueTestBase.TestElement> newPriorityQueue(int initialCapacity) {
        return new HeapPriorityQueue(TEST_ELEMENT_PRIORITY_COMPARATOR, initialCapacity);
    }

    @Override
    protected boolean testSetSemanticsAgainstDuplicateElements() {
        return false;
    }
}

