/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.runtime.state.JavaSerializer;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JavaSerializerTest
extends SerializerTestBase<Serializable> {
    private static final ClassLoaderUtils.ObjectAndClassLoader<Serializable> OUTSIDE_CLASS_LOADING = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
    private ClassLoader originalClassLoader;

    JavaSerializerTest() {
    }

    @BeforeEach
    public void setupClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OUTSIDE_CLASS_LOADING.getClassLoader());
    }

    @AfterEach
    public void restoreOriginalClassLoader() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    void guardTest() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Class.forName(((Serializable)OUTSIDE_CLASS_LOADING.getObject()).getClass().getName())).isInstanceOf(ClassNotFoundException.class)).withFailMessage("Test ineffective: The test class that should not be on the classpath is actually on the classpath.", new Object[0]);
    }

    protected TypeSerializer<Serializable> createSerializer() {
        Thread.currentThread().setContextClassLoader(OUTSIDE_CLASS_LOADING.getClassLoader());
        return new JavaSerializer();
    }

    protected int getLength() {
        return -1;
    }

    protected Class<Serializable> getTypeClass() {
        return Serializable.class;
    }

    protected Serializable[] getTestData() {
        return new Serializable[]{new Integer(42), new File("/some/path/that/I/made/up"), (Serializable)OUTSIDE_CLASS_LOADING.getObject(), new Tuple1((Object)((Serializable)OUTSIDE_CLASS_LOADING.getObject()))};
    }

    public void testInstantiate() {
    }
}

