/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.InputConsumableDecider;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;

public class TestingInputConsumableDecider
implements InputConsumableDecider {
    private final Set<SchedulingExecutionVertex> inputConsumableExecutionVertices = new HashSet<SchedulingExecutionVertex>();
    private final Set<SchedulingExecutionVertex> sourceVertices = new HashSet<SchedulingExecutionVertex>();
    private SchedulingExecutionVertex lastExecutionToDecideInputConsumable;

    public boolean isInputConsumable(SchedulingExecutionVertex executionVertex, Set<ExecutionVertexID> verticesToDeploy, Map<ConsumedPartitionGroup, Boolean> consumableStatusCache) {
        this.lastExecutionToDecideInputConsumable = executionVertex;
        return this.sourceVertices.contains(executionVertex) || this.inputConsumableExecutionVertices.contains(executionVertex);
    }

    public boolean isConsumableBasedOnFinishedProducers(ConsumedPartitionGroup consumedPartitionGroup) {
        return true;
    }

    public void setInputConsumable(SchedulingExecutionVertex executionVertex) {
        this.inputConsumableExecutionVertices.add(executionVertex);
    }

    public void addSourceVertices(Collection<SchedulingExecutionVertex> sourceVertices) {
        this.sourceVertices.addAll(sourceVertices);
    }

    public SchedulingExecutionVertex getLastExecutionToDecideInputConsumable() {
        return this.lastExecutionToDecideInputConsumable;
    }
}

