/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.TestingPhysicalSlotPayload;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SharedSlot;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SharedSlotTest {
    SharedSlotTest() {
    }

    @Test
    void testConstructorAssignsPayload() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        Assertions.assertThat((Object)physicalSlot.getPayload()).isNotNull();
    }

    @Test
    void testConstructorFailsIfSlotAlreadyHasAssignedPayload() {
        Assertions.assertThatThrownBy(() -> {
            TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
            physicalSlot.tryAssignPayload(new TestingPhysicalSlotPayload());
            new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testAllocateLogicalSlot() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
        Assertions.assertThat((Comparable)logicalSlot.getAllocationId()).isEqualTo((Object)physicalSlot.getAllocationId());
        Assertions.assertThat((Comparable)logicalSlot.getLocality()).isEqualTo((Object)Locality.UNKNOWN);
        Assertions.assertThat((Object)logicalSlot.getPayload()).isNull();
        Assertions.assertThat((Comparable)logicalSlot.getTaskManagerLocation()).isEqualTo((Object)physicalSlot.getTaskManagerLocation());
        Assertions.assertThat((Object)logicalSlot.getTaskManagerGateway()).isEqualTo((Object)physicalSlot.getTaskManagerGateway());
    }

    @Test
    void testAllocateLogicalSlotIssuesUniqueSlotRequestIds() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot1 = sharedSlot.allocateLogicalSlot();
        LogicalSlot logicalSlot2 = sharedSlot.allocateLogicalSlot();
        Assertions.assertThat((Comparable)logicalSlot1.getSlotRequestId()).isNotEqualTo((Object)logicalSlot2.getSlotRequestId());
    }

    @Test
    void testReturnLogicalSlotRejectsAliveSlots() {
        Assertions.assertThatThrownBy(() -> {
            TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
            SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
            LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
            sharedSlot.returnLogicalSlot(logicalSlot);
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testReturnLogicalSlotRejectsUnknownSlot() {
        Assertions.assertThatThrownBy(() -> {
            TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
            SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
            TestingLogicalSlot logicalSlot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            logicalSlot.releaseSlot(new Exception("test"));
            sharedSlot.returnLogicalSlot((LogicalSlot)logicalSlot);
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testReturnLogicalSlotTriggersExternalReleaseOnLastSlot() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        AtomicBoolean externalReleaseInitiated = new AtomicBoolean(false);
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> externalReleaseInitiated.set(true));
        LogicalSlot logicalSlot1 = sharedSlot.allocateLogicalSlot();
        LogicalSlot logicalSlot2 = sharedSlot.allocateLogicalSlot();
        logicalSlot1.releaseSlot((Throwable)new Exception("test"));
        Assertions.assertThat((AtomicBoolean)externalReleaseInitiated).isFalse();
        logicalSlot2.releaseSlot((Throwable)new Exception("test"));
        Assertions.assertThat((AtomicBoolean)externalReleaseInitiated).isTrue();
    }

    @Test
    void testReleaseDoesNotTriggersExternalRelease() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        AtomicBoolean externalReleaseInitiated = new AtomicBoolean(false);
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> externalReleaseInitiated.set(true));
        sharedSlot.release((Throwable)new Exception("test"));
        Assertions.assertThat((AtomicBoolean)externalReleaseInitiated).isFalse();
    }

    @Test
    void testReleaseAlsoReleasesLogicalSlots() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
        sharedSlot.release((Throwable)new Exception("test"));
        Assertions.assertThat((boolean)logicalSlot.isAlive()).isFalse();
    }

    @Test
    void testReleaseForbidsSubsequentLogicalSlotAllocations() {
        Assertions.assertThatThrownBy(() -> {
            TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
            SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
            sharedSlot.release((Throwable)new Exception("test"));
            sharedSlot.allocateLogicalSlot();
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testCanReturnLogicalSlotDuringRelease() {
        TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
        SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
        LogicalSlot logicalSlot1 = sharedSlot.allocateLogicalSlot();
        LogicalSlot logicalSlot2 = sharedSlot.allocateLogicalSlot();
        logicalSlot1.tryAssignPayload((LogicalSlot.Payload)new TestLogicalSlotPayload(cause -> {
            if (logicalSlot2.isAlive()) {
                logicalSlot2.releaseSlot(cause);
            }
        }));
        logicalSlot2.tryAssignPayload((LogicalSlot.Payload)new TestLogicalSlotPayload(cause -> {
            if (logicalSlot1.isAlive()) {
                logicalSlot1.releaseSlot(cause);
            }
        }));
        sharedSlot.release((Throwable)new Exception("test"));
        Assertions.assertThat((boolean)logicalSlot1.isAlive()).isFalse();
        Assertions.assertThat((boolean)logicalSlot2.isAlive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SharedSlot)sharedSlot).allocateLogicalSlot()).withFailMessage("Allocation of logical slot should have failed because the slot was released.", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testCannotAllocateLogicalSlotDuringRelease() {
        Assertions.assertThatThrownBy(() -> {
            TestingPhysicalSlot physicalSlot = TestingPhysicalSlot.builder().build();
            SharedSlot sharedSlot = new SharedSlot(new SlotRequestId(), (PhysicalSlot)physicalSlot, false, () -> {});
            LogicalSlot logicalSlot = sharedSlot.allocateLogicalSlot();
            logicalSlot.tryAssignPayload((LogicalSlot.Payload)new TestLogicalSlotPayload(ignored -> sharedSlot.allocateLogicalSlot()));
            sharedSlot.release((Throwable)new Exception("test"));
        }).isInstanceOf(IllegalStateException.class);
    }

    private static class TestLogicalSlotPayload
    implements LogicalSlot.Payload {
        private final Consumer<Throwable> failConsumer;

        public TestLogicalSlotPayload() {
            this.failConsumer = ignored -> {};
        }

        public TestLogicalSlotPayload(Consumer<Throwable> failConsumer) {
            this.failConsumer = failConsumer;
        }

        public void fail(Throwable cause) {
            this.failConsumer.accept(cause);
        }

        public CompletableFuture<?> getTerminalStateFuture() {
            return new CompletableFuture();
        }
    }
}

