/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.job.metrics.JobManagerOperatorMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.MetricsHandlerTestBase;

public class JobManagerOperatorMetricsHandlerTest
extends MetricsHandlerTestBase<JobManagerOperatorMetricsHandler> {
    private static final String TEST_JOB_ID = new JobID().toString();
    private static final String TEST_VERTEX_ID = new JobVertexID().toString();
    private static final String TEST_OPERATOR_NAME = "opname";

    @Override
    JobManagerOperatorMetricsHandler getMetricsHandler() {
        return new JobManagerOperatorMetricsHandler(this.leaderRetriever, TIMEOUT, TEST_HEADERS, this.mockMetricFetcher);
    }

    @Override
    QueryScopeInfo getQueryScopeInfo() {
        return new QueryScopeInfo.JobManagerOperatorQueryScopeInfo(TEST_JOB_ID, TEST_VERTEX_ID, TEST_OPERATOR_NAME);
    }

    @Override
    Map<String, String> getPathParameters() {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", TEST_JOB_ID);
        pathParameters.put("vertexid", TEST_VERTEX_ID);
        return pathParameters;
    }

    @Override
    String getExpectedIdForMetricName(String metricName) {
        return "opname." + metricName;
    }
}

