/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.net.SSLUtilsTest;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.RestServerEndpointITCase;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class RestServerSSLAuthITCase {
    private static final String KEY_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/local127.keystore").getFile();
    private static final String TRUST_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/local127.truststore").getFile();
    private static final String UNTRUSTED_KEY_STORE_FILE = RestServerSSLAuthITCase.class.getResource("/untrusted.keystore").getFile();
    private static final Duration timeout = Duration.ofSeconds(10L);
    private final Configuration clientConfig;
    private final Configuration serverConfig;

    public RestServerSSLAuthITCase(Tuple2<Configuration, Configuration> clientServerConfig) {
        this.clientConfig = (Configuration)clientServerConfig.f0;
        this.serverConfig = (Configuration)clientServerConfig.f1;
    }

    @Parameters
    public static Collection<Object[]> data() throws Exception {
        Tuple2<Configuration, Configuration> untrusted = RestServerSSLAuthITCase.getClientServerConfiguration();
        Configuration serverConfig = new Configuration((Configuration)untrusted.f1);
        serverConfig.set(SecurityOptions.SSL_REST_TRUSTSTORE, (Object)TRUST_STORE_FILE);
        serverConfig.set(SecurityOptions.SSL_REST_CERT_FINGERPRINT, (Object)SSLUtilsTest.getRestCertificateFingerprint(serverConfig, "flink.test").replaceAll("[0-9A-Z]", "0"));
        Configuration clientConfig = new Configuration((Configuration)untrusted.f0);
        clientConfig.set(SecurityOptions.SSL_REST_TRUSTSTORE, (Object)TRUST_STORE_FILE);
        Tuple2 withFingerprint = Tuple2.of((Object)clientConfig, (Object)serverConfig);
        return Arrays.asList({untrusted}, {withFingerprint});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    void testConnectFailure() throws Exception {
        RestClient restClient = null;
        TestRestServerEndpoint serverEndpoint = null;
        try {
            TestingRestfulGateway restfulGateway = new TestingRestfulGateway.Builder().build();
            RestServerEndpointITCase.TestVersionHandler testVersionHandler = new RestServerEndpointITCase.TestVersionHandler((GatewayRetriever<? extends RestfulGateway>)((GatewayRetriever)() -> CompletableFuture.completedFuture(restfulGateway)), RpcUtils.INF_TIMEOUT);
            serverEndpoint = TestRestServerEndpoint.builder(this.serverConfig).withHandler((RestHandlerSpecification)testVersionHandler.getMessageHeaders(), (ChannelInboundHandler)testVersionHandler).buildAndStart();
            restClient = new RestClient(this.clientConfig, Executors.directExecutor());
            FlinkAssertions.assertThatFuture((CompletableFuture)restClient.sendRequest(serverEndpoint.getServerAddress().getHostName(), serverEndpoint.getServerAddress().getPort(), (MessageHeaders)RestServerEndpointITCase.TestVersionHeaders.INSTANCE, (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), Collections.emptyList())).failsWithin(60L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(SSLException.class)});
        }
        finally {
            if (restClient != null) {
                restClient.shutdown(timeout);
            }
            if (serverEndpoint != null) {
                serverEndpoint.close();
            }
        }
    }

    private static Tuple2<Configuration, Configuration> getClientServerConfiguration() {
        Configuration baseConfig = new Configuration();
        baseConfig.set(RestOptions.BIND_PORT, (Object)"0");
        baseConfig.set(RestOptions.ADDRESS, (Object)"localhost");
        baseConfig.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
        baseConfig.set(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, (Object)true);
        baseConfig.set(SecurityOptions.SSL_ALGORITHMS, (Object)"TLS_RSA_WITH_AES_128_CBC_SHA");
        Configuration serverConfig = new Configuration(baseConfig);
        serverConfig.set(SecurityOptions.SSL_REST_TRUSTSTORE, (Object)TRUST_STORE_FILE);
        serverConfig.set(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, (Object)"password");
        serverConfig.set(SecurityOptions.SSL_REST_KEYSTORE, (Object)KEY_STORE_FILE);
        serverConfig.set(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, (Object)"password");
        serverConfig.set(SecurityOptions.SSL_REST_KEY_PASSWORD, (Object)"password");
        Configuration clientConfig = new Configuration(baseConfig);
        clientConfig.set(SecurityOptions.SSL_REST_TRUSTSTORE, (Object)UNTRUSTED_KEY_STORE_FILE);
        clientConfig.set(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, (Object)"password");
        clientConfig.set(SecurityOptions.SSL_REST_KEYSTORE, (Object)KEY_STORE_FILE);
        clientConfig.set(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, (Object)"password");
        clientConfig.set(SecurityOptions.SSL_REST_KEY_PASSWORD, (Object)"password");
        return Tuple2.of((Object)clientConfig, (Object)serverConfig);
    }
}

