/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.time.Duration;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RetryingRegistrationConfigurationTest {
    RetryingRegistrationConfigurationTest() {
    }

    @Test
    void testConfigurationParsing() {
        Configuration configuration = new Configuration();
        long initialRegistrationTimeout = 1L;
        long maxRegistrationTimeout = 2L;
        long refusedRegistrationDelay = 3L;
        long errorRegistrationDelay = 4L;
        configuration.set(ClusterOptions.INITIAL_REGISTRATION_TIMEOUT, (Object)Duration.ofMillis(1L));
        configuration.set(ClusterOptions.MAX_REGISTRATION_TIMEOUT, (Object)Duration.ofMillis(2L));
        configuration.set(ClusterOptions.REFUSED_REGISTRATION_DELAY, (Object)Duration.ofMillis(3L));
        configuration.set(ClusterOptions.ERROR_REGISTRATION_DELAY, (Object)Duration.ofMillis(4L));
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration((Configuration)configuration);
        Assertions.assertThat((long)retryingRegistrationConfiguration.getInitialRegistrationTimeoutMillis()).isEqualTo(1L);
        Assertions.assertThat((long)retryingRegistrationConfiguration.getMaxRegistrationTimeoutMillis()).isEqualTo(2L);
        Assertions.assertThat((long)retryingRegistrationConfiguration.getRefusedDelayMillis()).isEqualTo(3L);
        Assertions.assertThat((long)retryingRegistrationConfiguration.getErrorDelayMillis()).isEqualTo(4L);
    }
}

