/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.SeekableFileChannelInputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LargeRecordHandlerITCase {
    LargeRecordHandlerITCase() {
    }

    @Test
    void testRecordHandlerCompositeKey() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 1000;
        int NUM_RECORDS = 10;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            Tuple3 next;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(4096000L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List initialMemory = memMan.allocatePages((Object)owner, 6);
            List sortMemory = memMan.allocatePages((Object)owner, 994);
            TypeInformation[] types = new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, new ValueTypeInfo(SomeVeryLongValue.class), BasicTypeInfo.BYTE_TYPE_INFO};
            TupleTypeInfo typeInfo = new TupleTypeInfo(types);
            TupleSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
            TypeComparator comparator = typeInfo.createComparator(new int[]{2, 0}, new boolean[]{true, true}, 0, new ExecutionConfig());
            LargeRecordHandler handler = new LargeRecordHandler((TypeSerializer)serializer, comparator, (IOManager)ioMan, memMan, initialMemory, (TaskInvokable)owner, 128, owner.getExecutionConfig());
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            Random rnd = new Random();
            for (int i = 0; i < 10; ++i) {
                long val = rnd.nextLong();
                handler.addRecord((Object)new Tuple3((Object)val, (Object)new SomeVeryLongValue((int)val), (Object)((byte)val)));
                Assertions.assertThat((boolean)handler.hasData()).isTrue();
            }
            MutableObjectIterator sorted = handler.finishWriteAndSortKeys(sortMemory);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.addRecord((Object)new Tuple3((Object)92L, null, (Object)1))).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalStateException.class);
            Tuple3 previous = null;
            while ((next = (Tuple3)sorted.next(null)) != null) {
                Assertions.assertThat((int)((Long)next.f0).intValue()).isEqualTo(((SomeVeryLongValue)next.f1).val());
                Assertions.assertThat((byte)((Long)next.f0).byteValue()).isEqualTo(next.f2);
                if (previous != null) {
                    Assertions.assertThat((Byte)((Byte)previous.f2)).isLessThanOrEqualTo((Comparable)((Byte)next.f2));
                    Assertions.assertThat((((Byte)previous.f2).byteValue() != ((Byte)next.f2).byteValue() || (Long)previous.f0 <= (Long)next.f0 ? 1 : 0) != 0).isTrue();
                }
                previous = next;
            }
            handler.close();
            Assertions.assertThat((boolean)handler.hasData()).isFalse();
            handler.close();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.addRecord((Object)new Tuple3((Object)92L, null, (Object)1))).withFailMessage("should throw an exception", new Object[0])).isInstanceOf(IllegalStateException.class);
            Assertions.assertThat((boolean)memMan.verifyEmpty()).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void fileTest() {
        int PAGE_SIZE = 4096;
        int NUM_PAGES = 4;
        int NUM_RECORDS = 10;
        FileIOChannel.ID channel = null;
        try (IOManagerAsync ioMan = new IOManagerAsync();){
            int i;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(16384L).setPageSize(4096).build();
            DummyInvokable owner = new DummyInvokable();
            List memory = memMan.allocatePages((Object)owner, 4);
            TypeInformation[] types = new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, new ValueTypeInfo(SomeVeryLongValue.class), BasicTypeInfo.BYTE_TYPE_INFO};
            TupleTypeInfo typeInfo = new TupleTypeInfo(types);
            TupleSerializer serializer = typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl());
            channel = ioMan.createChannel();
            FileChannelOutputView out = new FileChannelOutputView(ioMan.createBlockChannelWriter(channel), memMan, memory, 4096);
            Random rnd = new Random();
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (i = 0; i < 10; ++i) {
                offsets.add(out.getWriteOffset());
                long val = rnd.nextLong();
                Tuple3 next = new Tuple3((Object)val, (Object)new SomeVeryLongValue((int)val), (Object)((byte)val));
                serializer.serialize((Object)next, (DataOutputView)out);
            }
            out.close();
            for (i = 1; i < offsets.size(); ++i) {
                Assertions.assertThat((Long)((Long)offsets.get(i))).isGreaterThan((Comparable)((Long)offsets.get(i - 1)));
            }
            memMan.allocatePages((Object)owner, (Collection)memory, 4);
            SeekableFileChannelInputView in = new SeekableFileChannelInputView((IOManager)ioMan, channel, memMan, memory, out.getBytesInLatestSegment());
            for (int i2 = 0; i2 < 10; ++i2) {
                in.seek(((Long)offsets.get(i2)).longValue());
                Tuple3 next = (Tuple3)serializer.deserialize((DataInputView)in);
                Assertions.assertThat((int)((Long)next.f0).intValue()).isEqualTo(((SomeVeryLongValue)next.f1).val());
                Assertions.assertThat((byte)((Long)next.f0).byteValue()).isEqualTo(next.f2);
            }
            in.closeAndDelete();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    public static final class SomeVeryLongValue
    implements Value {
        private static final long serialVersionUID = 1L;
        private static final byte[] BUFFER = new byte[50000000];
        private int val;

        public SomeVeryLongValue() {
        }

        public SomeVeryLongValue(int val) {
            this.val = val;
        }

        public int val() {
            return this.val;
        }

        public void read(DataInputView in) throws IOException {
            this.val = in.readInt();
            for (byte bufferByte : BUFFER) {
                byte b = in.readByte();
                Assertions.assertThat((byte)b).isEqualTo(bufferByte);
            }
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.val);
            out.write(BUFFER);
        }

        static {
            for (int i = 0; i < BUFFER.length; ++i) {
                SomeVeryLongValue.BUFFER[i] = (byte)i;
            }
        }
    }
}

