/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichGroupCombineFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.sort.ExternalSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.InMemorySorterFactory;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.runtime.util.EmptyMutableObjectIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExternalSorterTest {
    private static final ConfigOption<String> testOption = ConfigOptions.key((String)"test").stringType().noDefaultValue();

    ExternalSorterTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testInMemorySorterDisposal() throws Exception {
        TestingInMemorySorterFactory inMemorySorterFactory = new TestingInMemorySorterFactory();
        int numPages = 32;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x100000L).build();
        DummyInvokable parentTask = new DummyInvokable();
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            List memory = memoryManager.allocatePages((Object)parentTask, 32);
            ExternalSorter unilateralSortMerger = ExternalSorter.newBuilder((MemoryManager)memoryManager, (AbstractInvokable)parentTask, (TypeSerializer)TestData.getIntIntTupleSerializerFactory().getSerializer(), TestData.getIntIntTupleComparator()).maxNumFileHandles(2).enableSpilling((IOManager)ioManager, 1.0).memory(memory).sortBuffers(10).objectReuse(false).largeRecords(false).sorterFactory(inMemorySorterFactory).build(EmptyMutableObjectIterator.get());
            Collection<TestingInMemorySorter<?>> inMemorySorters = inMemorySorterFactory.getInMemorySorters();
            Assertions.assertThat(inMemorySorters).isNotEmpty();
            unilateralSortMerger.close();
            for (TestingInMemorySorter<?> inMemorySorter : inMemorySorters) {
                Assertions.assertThat((boolean)inMemorySorter.isDisposed()).isTrue();
            }
        }
        finally {
            memoryManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testOpeningCombineUdf() throws Exception {
        TestingInMemorySorterFactory inMemorySorterFactory = new TestingInMemorySorterFactory();
        int numPages = 32;
        MemoryManager memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x100000L).build();
        DummyInvokable parentTask = new DummyInvokable();
        Configuration config = new Configuration();
        config.set(testOption, (Object)"TEST");
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            List memory = memoryManager.allocatePages((Object)parentTask, 32);
            RichCombiner combiner = new RichCombiner();
            ExternalSorter unilateralSortMerger = ExternalSorter.newBuilder((MemoryManager)memoryManager, (AbstractInvokable)parentTask, (TypeSerializer)TestData.getIntIntTupleSerializerFactory().getSerializer(), TestData.getIntIntTupleComparator()).maxNumFileHandles(2).enableSpilling((IOManager)ioManager, 0.0).memory(memory).sortBuffers(10).objectReuse(false).largeRecords(false).sorterFactory(inMemorySorterFactory).withCombiner((GroupCombineFunction)combiner, config).build(EmptyMutableObjectIterator.get());
            unilateralSortMerger.getIterator();
            unilateralSortMerger.close();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)combiner.isOpen).withFailMessage("Combiner was not opened", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)combiner.isClosed).withFailMessage("Combiner was not closed", new Object[0])).isTrue();
        }
        finally {
            memoryManager.shutdown();
        }
    }

    private static final class TestingInMemorySorterFactory<T>
    implements InMemorySorterFactory<T> {
        private final Collection<TestingInMemorySorter<?>> inMemorySorters = new ArrayList(10);

        private TestingInMemorySorterFactory() {
        }

        Collection<TestingInMemorySorter<?>> getInMemorySorters() {
            return this.inMemorySorters;
        }

        public InMemorySorter<T> create(List<MemorySegment> sortSegments) {
            TestingInMemorySorter testingInMemorySorter = new TestingInMemorySorter();
            this.inMemorySorters.add(testingInMemorySorter);
            return testingInMemorySorter;
        }
    }

    private static final class TestingInMemorySorter<T>
    implements InMemorySorter<T> {
        private volatile boolean isDisposed;

        private TestingInMemorySorter() {
        }

        public boolean isDisposed() {
            return this.isDisposed;
        }

        public void reset() {
        }

        public boolean isEmpty() {
            return true;
        }

        public void dispose() {
            this.isDisposed = true;
        }

        public long getCapacity() {
            return 0L;
        }

        public long getOccupancy() {
            return 0L;
        }

        public T getRecord(int logicalPosition) throws IOException {
            return null;
        }

        public T getRecord(T reuse, int logicalPosition) throws IOException {
            return null;
        }

        public boolean write(T record) throws IOException {
            return false;
        }

        public MutableObjectIterator<T> getIterator() {
            return null;
        }

        public void writeToOutput(ChannelWriterOutputView output) throws IOException {
        }

        public void writeToOutput(ChannelWriterOutputView output, LargeRecordHandler<T> largeRecordsOutput) throws IOException {
        }

        public void writeToOutput(ChannelWriterOutputView output, int start, int num) throws IOException {
        }

        public int compare(int i, int j) {
            return 0;
        }

        public int compare(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
            return 0;
        }

        public void swap(int i, int j) {
        }

        public void swap(int segmentNumberI, int segmentOffsetI, int segmentNumberJ, int segmentOffsetJ) {
        }

        public int size() {
            return 0;
        }

        public int recordSize() {
            return 0;
        }

        public int recordsPerSegment() {
            return 0;
        }
    }

    private static final class RichCombiner
    extends RichGroupCombineFunction<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> {
        boolean isOpen = false;
        boolean isClosed = false;

        private RichCombiner() {
        }

        public void open(OpenContext openContext) throws Exception {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isOpen).withFailMessage("UDF was already opened", new Object[0])).isFalse();
            this.isOpen = true;
        }

        public void close() throws Exception {
            this.isClosed = true;
        }

        public void combine(Iterable<Tuple2<Integer, Integer>> values, Collector<Tuple2<Integer, Integer>> out) throws Exception {
        }
    }
}

