/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.function.LongConsumer;
import org.apache.flink.runtime.memory.SharedResources;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SharedResourcesTest {
    SharedResourcesTest() {
    }

    @Test
    void testAllocatedResourcesInMap() throws Exception {
        SharedResources resources = new SharedResources();
        TestResource tr = (TestResource)resources.getOrAllocateSharedResource("theType", new Object(), TestResource::new, 100L).resourceHandle();
        Assertions.assertThat((int)resources.getNumResources()).isOne();
        Assertions.assertThat((boolean)tr.closed).isFalse();
    }

    @Test
    void testIntermediateReleaseDoesNotRemoveFromMap() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder1 = new Object();
        Object leaseHolder2 = new Object();
        resources.getOrAllocateSharedResource("theType", leaseHolder1, TestResource::new, 100L);
        resources.getOrAllocateSharedResource("theType", leaseHolder2, TestResource::new, 100L);
        resources.release("theType", leaseHolder1);
        Assertions.assertThat((int)resources.getNumResources()).isOne();
    }

    @Test
    void testReleaseIsIdempotent() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder1 = new Object();
        Object leaseHolder2 = new Object();
        resources.getOrAllocateSharedResource("theType", leaseHolder1, TestResource::new, 100L);
        resources.getOrAllocateSharedResource("theType", leaseHolder2, TestResource::new, 100L);
        resources.release("theType", leaseHolder2);
        resources.release("theType", leaseHolder2);
        Assertions.assertThat((int)resources.getNumResources()).isOne();
    }

    @Test
    void testLastReleaseRemovesFromMap() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder = new Object();
        resources.getOrAllocateSharedResource("theType", leaseHolder, TestResource::new, 100L);
        resources.release("theType", leaseHolder);
        Assertions.assertThat((int)resources.getNumResources()).isZero();
    }

    @Test
    void testLastReleaseDisposesResource() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder = new Object();
        TestResource tr = (TestResource)resources.getOrAllocateSharedResource("theType", leaseHolder, TestResource::new, 100L).resourceHandle();
        resources.release("theType", leaseHolder);
        Assertions.assertThat((boolean)tr.closed).isTrue();
    }

    @Test
    void testLastReleaseCallsReleaseHook() throws Exception {
        String type = "theType";
        long size = 100L;
        SharedResources resources = new SharedResources();
        Object leaseHolder = new Object();
        TestReleaseHook hook = new TestReleaseHook(100L);
        resources.getOrAllocateSharedResource("theType", leaseHolder, TestResource::new, 100L);
        resources.release("theType", leaseHolder, (LongConsumer)hook);
        Assertions.assertThat((boolean)hook.wasCalled).isTrue();
    }

    @Test
    void testReleaseNoneExistingLease() throws Exception {
        SharedResources resources = new SharedResources();
        resources.release("theType", new Object());
        Assertions.assertThat((int)resources.getNumResources()).isZero();
    }

    private static final class TestResource
    implements AutoCloseable {
        final long size;
        boolean closed;

        TestResource(long size) {
            this.size = size;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    private static final class TestReleaseHook
    implements LongConsumer {
        private final long expectedValue;
        boolean wasCalled;

        TestReleaseHook(long expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public void accept(long value) {
            this.wasCalled = true;
            Assertions.assertThat((long)value).isEqualTo(this.expectedValue);
        }
    }
}

