/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.concurrent;

import java.util.Random;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.iterative.concurrent.SuperstepBarrier;
import org.apache.flink.runtime.iterative.event.AllWorkersDoneEvent;
import org.apache.flink.runtime.iterative.event.TerminationEvent;
import org.junit.Assert;
import org.junit.Test;

public class SuperstepBarrierTest {
    @Test
    public void syncAllWorkersDone() throws InterruptedException {
        for (int n = 0; n < 20; ++n) {
            this.sync((TaskEvent)new AllWorkersDoneEvent());
        }
    }

    @Test
    public void syncTermination() throws InterruptedException {
        for (int n = 0; n < 20; ++n) {
            this.sync((TaskEvent)new TerminationEvent());
        }
    }

    private void sync(TaskEvent event) throws InterruptedException {
        TerminationSignaled terminationSignaled = new TerminationSignaled();
        SuperstepBarrier barrier = new SuperstepBarrier(this.getClass().getClassLoader());
        barrier.setup();
        Thread headThread = new Thread(new IterationHead(barrier, terminationSignaled));
        Thread syncThread = new Thread(new IterationSync(barrier, event));
        headThread.start();
        syncThread.start();
        headThread.join();
        syncThread.join();
        if (event instanceof TerminationEvent) {
            Assert.assertTrue((boolean)terminationSignaled.isTerminationSignaled());
        } else {
            Assert.assertFalse((boolean)terminationSignaled.isTerminationSignaled());
        }
    }

    class TerminationSignaled {
        private volatile boolean terminationSignaled;

        TerminationSignaled() {
        }

        public boolean isTerminationSignaled() {
            return this.terminationSignaled;
        }

        public void setTerminationSignaled() {
            this.terminationSignaled = true;
        }
    }

    class IterationHead
    implements Runnable {
        private final SuperstepBarrier barrier;
        private final TerminationSignaled terminationSignaled;
        private final Random random;

        IterationHead(SuperstepBarrier barrier, TerminationSignaled terminationSignaled) {
            this.barrier = barrier;
            this.terminationSignaled = terminationSignaled;
            this.random = new Random();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.random.nextInt(10));
                this.barrier.waitForOtherWorkers();
                if (this.barrier.terminationSignaled()) {
                    this.terminationSignaled.setTerminationSignaled();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    class IterationSync
    implements Runnable {
        private final SuperstepBarrier barrier;
        private final TaskEvent event;
        private final Random random;

        IterationSync(SuperstepBarrier barrier, TaskEvent event) {
            this.barrier = barrier;
            this.event = event;
            this.random = new Random();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.random.nextInt(10));
                this.barrier.onEvent(this.event);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

