/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.TestSingleInputGate;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.MutableObjectIterator;

public class IteratorWrappingTestSingleInputGate<T extends IOReadableWritable>
extends TestSingleInputGate {
    private final TestInputChannel inputChannel;
    private final int bufferSize;
    private MutableObjectIterator<T> inputIterator;
    private DataOutputSerializer serializer;
    private final T reuse;

    public IteratorWrappingTestSingleInputGate(int bufferSize, int gateIndex, MutableObjectIterator<T> iterator, Class<T> recordType) throws IOException, InterruptedException {
        super(1, gateIndex, false);
        this.inputChannel = new TestInputChannel(this.inputGate, 0);
        this.bufferSize = bufferSize;
        this.reuse = (IOReadableWritable)InstantiationUtil.instantiate(recordType);
        this.wrapIterator(iterator);
    }

    private IteratorWrappingTestSingleInputGate<T> wrapIterator(MutableObjectIterator<T> iterator) throws IOException, InterruptedException {
        this.inputIterator = iterator;
        this.serializer = new DataOutputSerializer(128);
        TestInputChannel.BufferAndAvailabilityProvider answer = new TestInputChannel.BufferAndAvailabilityProvider(){
            private boolean hasData;
            {
                this.hasData = IteratorWrappingTestSingleInputGate.this.inputIterator.next(IteratorWrappingTestSingleInputGate.this.reuse) != null;
            }

            @Override
            public Optional<InputChannel.BufferAndAvailability> getBufferAvailability() throws IOException {
                if (this.hasData) {
                    ByteBuffer serializedRecord = RecordWriter.serializeRecord((DataOutputSerializer)IteratorWrappingTestSingleInputGate.this.serializer, IteratorWrappingTestSingleInputGate.this.reuse);
                    BufferBuilder bufferBuilder = BufferBuilderTestUtils.createBufferBuilder(IteratorWrappingTestSingleInputGate.this.bufferSize);
                    BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
                    bufferBuilder.appendAndCommit(serializedRecord);
                    this.hasData = IteratorWrappingTestSingleInputGate.this.inputIterator.next(IteratorWrappingTestSingleInputGate.this.reuse) != null;
                    Buffer.DataType nextDataType = this.hasData ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.EVENT_BUFFER;
                    return Optional.of(new InputChannel.BufferAndAvailability(bufferConsumer.build(), nextDataType, 0, 0));
                }
                IteratorWrappingTestSingleInputGate.this.inputChannel.setReleased();
                return Optional.of(new InputChannel.BufferAndAvailability(EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE, (boolean)false), Buffer.DataType.NONE, 0, 0));
            }
        };
        this.inputChannel.addBufferAndAvailability(answer);
        this.inputGate.setInputChannels(new InputChannel[]{this.inputChannel});
        return this;
    }

    public IteratorWrappingTestSingleInputGate<T> notifyNonEmpty() {
        this.inputGate.notifyChannelNonEmpty((InputChannel)this.inputChannel);
        return this;
    }
}

