/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyClient;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;

public class NettyTestUtil {
    static final int DEFAULT_SEGMENT_SIZE = 1024;

    static NettyServer initServer(NettyConfig config, NettyProtocol protocol, NettyBufferPool bufferPool) throws Exception {
        NettyServer server = new NettyServer(config);
        try {
            server.init(protocol, bufferPool);
        }
        catch (Exception e) {
            server.shutdown();
            throw e;
        }
        return server;
    }

    static NettyServer initServer(NettyConfig config, NettyBufferPool bufferPool, Function<SSLHandlerFactory, NettyServer.ServerChannelInitializer> channelInitializer) throws Exception {
        NettyServer server = new NettyServer(config);
        try {
            server.init(bufferPool, channelInitializer);
        }
        catch (Exception e) {
            server.shutdown();
            throw e;
        }
        return server;
    }

    static NettyClient initClient(NettyConfig config, NettyProtocol protocol, NettyBufferPool bufferPool) throws Exception {
        NettyClient client = new NettyClient(config);
        try {
            client.init(protocol, bufferPool);
        }
        catch (Exception e) {
            client.shutdown();
            throw e;
        }
        return client;
    }

    static NettyServerAndClient initServerAndClient(NettyProtocol protocol) throws Exception {
        int attempts = 42;
        while (true) {
            try {
                return NettyTestUtil.initServerAndClient(protocol, NettyTestUtil.createConfig());
            }
            catch (Exception ex) {
                if (ex instanceof BindException || ExceptionUtils.findThrowableWithMessage((Throwable)ex, (String)"Address already in use").isPresent()) continue;
                throw ex;
                if (attempts-- >= 0) continue;
                throw new Exception("Failed to initialize netty server and client", ex);
            }
            break;
        }
    }

    static NettyServerAndClient initServerAndClient(NettyProtocol protocol, NettyConfig config) throws Exception {
        NettyBufferPool bufferPool = new NettyBufferPool(1);
        NettyClient client = NettyTestUtil.initClient(config, protocol, bufferPool);
        NettyServer server = NettyTestUtil.initServer(config, protocol, bufferPool);
        return new NettyServerAndClient(server, client);
    }

    static Channel connect(NettyServerAndClient serverAndClient) throws Exception {
        return NettyTestUtil.connect(serverAndClient.client(), serverAndClient.server());
    }

    static Channel connect(NettyClient client, NettyServer server) throws Exception {
        NettyConfig config = server.getConfig();
        return client.connect(new InetSocketAddress(config.getServerAddress(), (int)server.getListeningPort())).sync().channel();
    }

    static void awaitClose(Channel ch) throws InterruptedException {
        while (ch.isActive()) {
            ch.closeFuture().await(1L, TimeUnit.SECONDS);
        }
    }

    static void shutdown(NettyServerAndClient serverAndClient) {
        if (serverAndClient != null) {
            if (serverAndClient.server() != null) {
                serverAndClient.server().shutdown();
            }
            if (serverAndClient.client() != null) {
                serverAndClient.client().shutdown();
            }
        }
    }

    static NettyConfig createConfig() throws Exception {
        return NettyTestUtil.createConfig(1024, new Configuration());
    }

    static NettyConfig createConfig(int segmentSize) throws Exception {
        return NettyTestUtil.createConfig(segmentSize, new Configuration());
    }

    static NettyConfig createConfig(Configuration config) throws Exception {
        return NettyTestUtil.createConfig(1024, config);
    }

    static NettyConfig createConfig(int segmentSize, Configuration config) throws Exception {
        Preconditions.checkArgument((segmentSize > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)config);
        try (NetUtils.Port port = NetUtils.getAvailablePort();){
            NettyConfig nettyConfig = new NettyConfig(InetAddress.getLocalHost(), port.getPort(), segmentSize, 1, config);
            return nettyConfig;
        }
    }

    static <T extends NettyMessage> T encodeAndDecode(T msg, EmbeddedChannel channel) {
        ByteBuf encoded;
        channel.writeOutbound(new Object[]{msg});
        boolean msgNotEmpty = false;
        while ((encoded = (ByteBuf)channel.readOutbound()) != null) {
            msgNotEmpty = channel.writeInbound(new Object[]{encoded});
        }
        Assertions.assertThat((boolean)msgNotEmpty).isTrue();
        return (T)((NettyMessage)channel.readInbound());
    }

    static void verifyErrorResponse(NettyMessage.ErrorResponse expected, NettyMessage.ErrorResponse actual) {
        Assertions.assertThat((Comparable)actual.receiverId).isEqualTo((Object)expected.receiverId);
        Assertions.assertThat((Throwable)expected.cause).hasSameClassAs((Object)actual.cause);
        Assertions.assertThat((String)expected.cause.getMessage()).isEqualTo(actual.cause.getMessage());
        if (expected.receiverId == null) {
            Assertions.assertThat((boolean)actual.isFatalError()).isTrue();
        }
    }

    static void verifyBufferResponseHeader(NettyMessage.BufferResponse expected, NettyMessage.BufferResponse actual) {
        Assertions.assertThat((int)expected.backlog).isEqualTo(actual.backlog);
        Assertions.assertThat((int)expected.sequenceNumber).isEqualTo(actual.sequenceNumber);
        Assertions.assertThat((int)expected.bufferSize).isEqualTo(actual.bufferSize);
        Assertions.assertThat((Comparable)expected.receiverId).isEqualTo((Object)actual.receiverId);
        Assertions.assertThat((int)expected.subpartitionId).isEqualTo(actual.subpartitionId);
    }

    static final class NettyServerAndClient {
        private final NettyServer server;
        private final NettyClient client;

        NettyServerAndClient(NettyServer server, NettyClient client) {
            this.server = (NettyServer)Preconditions.checkNotNull((Object)server);
            this.client = (NettyClient)Preconditions.checkNotNull((Object)client);
        }

        NettyServer server() {
            return this.server;
        }

        NettyClient client() {
            return this.client;
        }

        ConnectionID getConnectionID(ResourceID resourceID, int connectionIndex) {
            return new ConnectionID(resourceID, new InetSocketAddress(this.server.getConfig().getServerAddress(), (int)this.server.getListeningPort()), connectionIndex);
        }
    }

    static final class NoOpProtocol
    extends NettyProtocol {
        NoOpProtocol() {
            super(null, null);
        }

        public ChannelHandler[] getServerChannelHandlers() {
            return new ChannelHandler[0];
        }

        public ChannelHandler[] getClientChannelHandlers() {
            return new ChannelHandler[0];
        }
    }
}

