/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.shaded.netty4.io.netty.util.ResourceLeakDetector;
import org.apache.flink.shaded.netty4.io.netty.util.ResourceLeakDetectorFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;

public class NettyLeakDetectionExtension
implements BeforeAllCallback,
AfterAllCallback {
    @GuardedBy(value="refCountLock")
    private static ResourceLeakDetectorFactory previousLeakDetector;
    @GuardedBy(value="refCountLock")
    private static ResourceLeakDetector.Level previousLeakDetectorLevel;
    private static final Object refCountLock;
    private static int refCount;

    public NettyLeakDetectionExtension() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)LoggerFactory.getLogger(ResourceLeakDetector.class).isErrorEnabled()).withFailMessage("Error logging must be enabled for the ResourceLeakDetector.", new Object[0])).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        Object object = refCountLock;
        synchronized (object) {
            if (refCount == 0) {
                previousLeakDetector = ResourceLeakDetectorFactory.instance();
                previousLeakDetectorLevel = ResourceLeakDetector.getLevel();
                ++refCount;
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
                ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)new FailingResourceLeakDetectorFactory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext context) throws Exception {
        Object object = refCountLock;
        synchronized (object) {
            if (--refCount == 0) {
                ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)previousLeakDetector);
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)previousLeakDetectorLevel);
            }
        }
    }

    static {
        refCountLock = new Object();
        refCount = 0;
    }

    private static class FailingResourceLeakDetectorFactory
    extends ResourceLeakDetectorFactory {
        private FailingResourceLeakDetectorFactory() {
        }

        public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval, long maxActive) {
            return new FailingResourceLeakDetector(resource, samplingInterval);
        }
    }

    private static class FailingResourceLeakDetector<T>
    extends ResourceLeakDetector<T> {
        FailingResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
            super(resourceType, samplingInterval);
        }

        protected void reportTracedLeak(String resourceType, String records) {
            super.reportTracedLeak(resourceType, records);
            org.junit.jupiter.api.Assertions.fail((String)String.format("LEAK: %s.release() was not called before it's garbage-collected.%s", resourceType, records));
        }

        protected void reportUntracedLeak(String resourceType) {
            super.reportUntracedLeak(resourceType);
            org.junit.jupiter.api.Assertions.fail((String)String.format("LEAK: %s.release() was not called before it's garbage-collected.", resourceType));
        }
    }
}

