/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.net.ExtendedSocketOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyClient;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOption;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.Epoll;
import org.apache.flink.shaded.netty4.io.netty.channel.epoll.EpollChannelOption;
import org.apache.flink.util.NetUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;

class NettyClientTest {
    NettyClientTest() {
    }

    @Test
    void testSetKeepaliveOptionWithNioConfigurable() throws Exception {
        Assumptions.assumeThat((boolean)NettyClientTest.keepaliveForNioConfigurable()).isTrue();
        Assumptions.assumeThat((boolean)Epoll.isAvailable()).isFalse();
        Configuration config = new Configuration();
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_IDLE_SECONDS, (Object)300);
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_INTERVAL_SECONDS, (Object)10);
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_COUNT, (Object)8);
        try (NetUtils.Port clientPort = NetUtils.getAvailablePort();){
            NettyClient client = NettyClientTest.createNettyClient(config, clientPort);
            Map<String, Object> options = client.getBootstrap().config().options().entrySet().stream().collect(Collectors.toMap(e -> ((ChannelOption)e.getKey()).name(), Map.Entry::getValue));
            ((MapAssert)((MapAssert)Assertions.assertThat(options).containsEntry((Object)"TCP_KEEPIDLE", (Object)300)).containsEntry((Object)"TCP_KEEPINTERVAL", (Object)10)).containsEntry((Object)"TCP_KEEPCOUNT", (Object)8);
        }
    }

    @Test
    void testSetKeepaliveOptionWithNioNotConfigurable() throws Exception {
        Assumptions.assumeThat((boolean)NettyClientTest.keepaliveForNioConfigurable()).isFalse();
        Assumptions.assumeThat((boolean)Epoll.isAvailable()).isFalse();
        Configuration config = new Configuration();
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_IDLE_SECONDS, (Object)300);
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_INTERVAL_SECONDS, (Object)10);
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_COUNT, (Object)8);
        try (NetUtils.Port clientPort = NetUtils.getAvailablePort();){
            NettyClient client = NettyClientTest.createNettyClient(config, clientPort);
            Map<String, Object> options = client.getBootstrap().config().options().entrySet().stream().collect(Collectors.toMap(e -> ((ChannelOption)e.getKey()).name(), Map.Entry::getValue));
            Assertions.assertThat(options).doesNotContainKeys((Object[])new String[]{"TCP_KEEPIDLE", "TCP_KEEPINTERVAL", "TCP_KEEPCOUNT"});
        }
    }

    @Test
    void testSetKeepaliveOptionWithEpoll() throws Exception {
        Assumptions.assumeThat((boolean)Epoll.isAvailable()).isTrue();
        Configuration config = new Configuration();
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_IDLE_SECONDS, (Object)300);
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_INTERVAL_SECONDS, (Object)10);
        config.set(NettyShuffleEnvironmentOptions.CLIENT_TCP_KEEP_COUNT, (Object)8);
        try (NetUtils.Port clientPort = NetUtils.getAvailablePort();){
            NettyClient client = NettyClientTest.createNettyClient(config, clientPort);
            Map options = client.getBootstrap().config().options();
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)options).containsEntry((Object)EpollChannelOption.TCP_KEEPIDLE, (Object)300)).containsEntry((Object)EpollChannelOption.TCP_KEEPINTVL, (Object)10)).containsEntry((Object)EpollChannelOption.TCP_KEEPCNT, (Object)8);
        }
    }

    private static boolean keepaliveForNioConfigurable() {
        try {
            ExtendedSocketOptions.class.getField("TCP_KEEPIDLE");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        return true;
    }

    private static NettyClient createNettyClient(Configuration config, NetUtils.Port port) throws Exception {
        NettyConfig nettyClientConfig = new NettyConfig(InetAddress.getLoopbackAddress(), port.getPort(), 1024, 1, config);
        NettyBufferPool bufferPool = new NettyBufferPool(1);
        NettyProtocol protocol = new NettyProtocol(null, null);
        return NettyTestUtil.initClient(nettyClientConfig, protocol, bufferPool);
    }
}

