/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.iterative.event.AllWorkersDoneEvent;
import org.apache.flink.runtime.iterative.event.TerminationEvent;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskEventDispatcherTest {
    TaskEventDispatcherTest() {
    }

    @Test
    void registerPartitionTwice() {
        ResultPartitionID partitionId = new ResultPartitionID();
        TaskEventDispatcher ted = new TaskEventDispatcher();
        ted.registerPartition(partitionId);
        Assertions.assertThatThrownBy(() -> ted.registerPartition(partitionId)).hasMessageContaining("already registered at task event dispatcher").isInstanceOf(IllegalStateException.class);
    }

    @Test
    void subscribeToEventNotRegistered() {
        TaskEventDispatcher ted = new TaskEventDispatcher();
        Assertions.assertThatThrownBy(() -> ted.subscribeToEvent(new ResultPartitionID(), (EventListener)new ZeroShotEventListener(), TaskEvent.class)).hasMessageContaining("not registered at task event dispatcher").isInstanceOf(IllegalStateException.class);
    }

    @Test
    void publishSubscribe() {
        ResultPartitionID partitionId1 = new ResultPartitionID();
        ResultPartitionID partitionId2 = new ResultPartitionID();
        TaskEventDispatcher ted = new TaskEventDispatcher();
        AllWorkersDoneEvent event1 = new AllWorkersDoneEvent();
        TerminationEvent event2 = new TerminationEvent();
        Assertions.assertThat((boolean)ted.publish(partitionId1, (TaskEvent)event1)).isFalse();
        ted.registerPartition(partitionId1);
        ted.registerPartition(partitionId2);
        Assertions.assertThat((boolean)ted.publish(partitionId1, (TaskEvent)event1)).isTrue();
        OneShotEventListener eventListener1a = new OneShotEventListener((TaskEvent)event1);
        ZeroShotEventListener eventListener1b = new ZeroShotEventListener();
        ZeroShotEventListener eventListener2 = new ZeroShotEventListener();
        OneShotEventListener eventListener3 = new OneShotEventListener((TaskEvent)event2);
        ted.subscribeToEvent(partitionId1, (EventListener)eventListener1a, AllWorkersDoneEvent.class);
        ted.subscribeToEvent(partitionId2, (EventListener)eventListener1b, AllWorkersDoneEvent.class);
        ted.subscribeToEvent(partitionId1, (EventListener)eventListener2, TaskEvent.class);
        ted.subscribeToEvent(partitionId1, (EventListener)eventListener3, TerminationEvent.class);
        Assertions.assertThat((boolean)ted.publish(partitionId1, (TaskEvent)event1)).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)eventListener1a.fired).withFailMessage("listener should have fired for AllWorkersDoneEvent", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)eventListener3.fired).withFailMessage("listener should not have fired for AllWorkersDoneEvent", new Object[0])).isFalse();
        Assertions.assertThat((boolean)ted.publish(partitionId1, (TaskEvent)event2)).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)eventListener3.fired).withFailMessage("listener should have fired for TerminationEvent", new Object[0])).isTrue();
    }

    @Test
    void unregisterPartition() {
        ResultPartitionID partitionId1 = new ResultPartitionID();
        ResultPartitionID partitionId2 = new ResultPartitionID();
        TaskEventDispatcher ted = new TaskEventDispatcher();
        AllWorkersDoneEvent event = new AllWorkersDoneEvent();
        Assertions.assertThat((boolean)ted.publish(partitionId1, (TaskEvent)event)).isFalse();
        ted.registerPartition(partitionId1);
        ted.registerPartition(partitionId2);
        OneShotEventListener eventListener1a = new OneShotEventListener((TaskEvent)event);
        ZeroShotEventListener eventListener1b = new ZeroShotEventListener();
        OneShotEventListener eventListener2 = new OneShotEventListener((TaskEvent)event);
        ted.subscribeToEvent(partitionId1, (EventListener)eventListener1a, AllWorkersDoneEvent.class);
        ted.subscribeToEvent(partitionId2, (EventListener)eventListener1b, AllWorkersDoneEvent.class);
        ted.subscribeToEvent(partitionId1, (EventListener)eventListener2, AllWorkersDoneEvent.class);
        ted.unregisterPartition(partitionId2);
        Assertions.assertThat((boolean)ted.publish(partitionId1, (TaskEvent)event)).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)eventListener1a.fired).withFailMessage("listener should have fired for AllWorkersDoneEvent", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)eventListener2.fired).withFailMessage("listener should have fired for AllWorkersDoneEvent", new Object[0])).isTrue();
        Assertions.assertThat((boolean)ted.publish(partitionId2, (TaskEvent)event)).isFalse();
    }

    @Test
    void clearAll() throws Exception {
        ResultPartitionID partitionId = new ResultPartitionID();
        TaskEventDispatcher ted = new TaskEventDispatcher();
        ted.registerPartition(partitionId);
        ZeroShotEventListener eventListener1 = new ZeroShotEventListener();
        ted.subscribeToEvent(partitionId, (EventListener)eventListener1, AllWorkersDoneEvent.class);
        ted.clearAll();
        Assertions.assertThat((boolean)ted.publish(partitionId, (TaskEvent)new AllWorkersDoneEvent())).isFalse();
    }

    private static class OneShotEventListener
    implements EventListener<TaskEvent> {
        private final TaskEvent expected;
        boolean fired = false;

        OneShotEventListener(TaskEvent expected) {
            this.expected = expected;
        }

        public void onEvent(TaskEvent actual) {
            Preconditions.checkState((!this.fired ? 1 : 0) != 0, (Object)"Should only fire once");
            this.fired = true;
            Preconditions.checkArgument((actual == this.expected ? 1 : 0) != 0, (String)"Fired on unexpected event: %s (expected: %s)", (Object[])new Object[]{actual, this.expected});
        }
    }

    private static class ZeroShotEventListener
    implements EventListener<TaskEvent> {
        private ZeroShotEventListener() {
        }

        public void onEvent(TaskEvent actual) {
            throw new IllegalStateException("Should never fire");
        }
    }
}

