/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.DefaultHeartbeatMonitor;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerSenderImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatMonitor;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public class TestingHeartbeatServices
implements HeartbeatServices {
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private static final long DEFAULT_HEARTBEAT_TIMEOUT = 10000L;
    private static final long DEFAULT_HEARTBEAT_INTERVAL = 1000L;
    private final Map<ResourceID, Collection<HeartbeatManagerImpl>> heartbeatManagers = new ConcurrentHashMap<ResourceID, Collection<HeartbeatManagerImpl>>();
    private final Map<ResourceID, Collection<HeartbeatManagerSenderImpl>> heartbeatManagerSenders = new ConcurrentHashMap<ResourceID, Collection<HeartbeatManagerSenderImpl>>();

    public TestingHeartbeatServices() {
        this(1000L, 10000L);
    }

    public TestingHeartbeatServices(long heartbeatInterval) {
        this(heartbeatInterval, 10000L);
    }

    public TestingHeartbeatServices(long heartbeatInterval, long heartbeatTimeout) {
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManager(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        HeartbeatManagerImpl heartbeatManager = new HeartbeatManagerImpl(this.heartbeatTimeout, -1, resourceId, heartbeatListener, mainThreadExecutor, log, new TestingHeartbeatMonitorFactory());
        this.heartbeatManagers.compute(resourceId, (resourceID, heartbeatManagers) -> {
            ArrayList<HeartbeatManagerImpl> result = heartbeatManagers != null ? heartbeatManagers : new ArrayList<HeartbeatManagerImpl>();
            result.add(heartbeatManager);
            return result;
        });
        return heartbeatManager;
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManagerSender(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        HeartbeatManagerSenderImpl heartbeatManager = new HeartbeatManagerSenderImpl(this.heartbeatInterval, this.heartbeatTimeout, -1, resourceId, heartbeatListener, mainThreadExecutor, log, new TestingHeartbeatMonitorFactory());
        this.heartbeatManagerSenders.compute(resourceId, (resourceID, heartbeatManagers) -> {
            ArrayList<HeartbeatManagerSenderImpl> result = heartbeatManagers != null ? heartbeatManagers : new ArrayList<HeartbeatManagerSenderImpl>();
            result.add(heartbeatManager);
            return result;
        });
        return heartbeatManager;
    }

    public void triggerHeartbeatTimeout(ResourceID managerResourceId, ResourceID targetResourceId) {
        Collection<HeartbeatManagerSenderImpl> heartbeatManagerSenderList;
        boolean triggered = false;
        Collection<HeartbeatManagerImpl> heartbeatManagerList = this.heartbeatManagers.get(managerResourceId);
        if (heartbeatManagerList != null) {
            for (HeartbeatManagerImpl heartbeatManager : heartbeatManagerList) {
                TestingHeartbeatMonitor monitor = (TestingHeartbeatMonitor)((Object)heartbeatManager.getHeartbeatTargets().get(targetResourceId));
                if (monitor == null) continue;
                monitor.triggerHeartbeatTimeout();
                triggered = true;
            }
        }
        if ((heartbeatManagerSenderList = this.heartbeatManagerSenders.get(managerResourceId)) != null) {
            for (HeartbeatManagerSenderImpl heartbeatManagerSender : heartbeatManagerSenderList) {
                TestingHeartbeatMonitor monitor = (TestingHeartbeatMonitor)((Object)heartbeatManagerSender.getHeartbeatTargets().get(targetResourceId));
                if (monitor == null) continue;
                monitor.triggerHeartbeatTimeout();
                triggered = true;
            }
        }
        Preconditions.checkState((boolean)triggered, (Object)("There is no target " + targetResourceId + " monitored under Heartbeat manager " + managerResourceId));
    }

    static class TestingHeartbeatMonitorFactory<O>
    implements HeartbeatMonitor.Factory<O> {
        TestingHeartbeatMonitorFactory() {
        }

        public HeartbeatMonitor<O> createHeartbeatMonitor(ResourceID resourceID, HeartbeatTarget<O> heartbeatTarget, ScheduledExecutor mainThreadExecutor, HeartbeatListener<?, O> heartbeatListener, long heartbeatTimeoutIntervalMs, int failedRpcRequestsUntilUnreachable) {
            return new TestingHeartbeatMonitor<O>(resourceID, heartbeatTarget, mainThreadExecutor, heartbeatListener, heartbeatTimeoutIntervalMs, failedRpcRequestsUntilUnreachable);
        }
    }

    static class TestingHeartbeatMonitor<O>
    extends DefaultHeartbeatMonitor<O> {
        private volatile boolean timeoutTriggered = false;

        TestingHeartbeatMonitor(ResourceID resourceID, HeartbeatTarget<O> heartbeatTarget, ScheduledExecutor scheduledExecutor, HeartbeatListener<?, O> heartbeatListener, long heartbeatTimeoutIntervalMs, int failedRpcRequestsUntilUnreachable) {
            super(resourceID, heartbeatTarget, scheduledExecutor, heartbeatListener, heartbeatTimeoutIntervalMs, failedRpcRequestsUntilUnreachable);
        }

        public void reportHeartbeat() {
            if (!this.timeoutTriggered) {
                super.reportHeartbeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetHeartbeatTimeout(long heartbeatTimeout) {
            TestingHeartbeatMonitor testingHeartbeatMonitor = this;
            synchronized (testingHeartbeatMonitor) {
                if (this.timeoutTriggered) {
                    super.resetHeartbeatTimeout(0L);
                } else {
                    super.resetHeartbeatTimeout(heartbeatTimeout);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void triggerHeartbeatTimeout() {
            TestingHeartbeatMonitor testingHeartbeatMonitor = this;
            synchronized (testingHeartbeatMonitor) {
                this.timeoutTriggered = true;
                this.resetHeartbeatTimeout(0L);
            }
        }
    }
}

