/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.function.FunctionUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestingComponentMainThreadExecutor {
    @Nonnull
    private final ComponentMainThreadExecutor mainThreadExecutor;

    public TestingComponentMainThreadExecutor(@Nonnull ComponentMainThreadExecutor mainThreadExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
    }

    public <U> U execute(@Nonnull SupplierWithException<U, Throwable> supplierWithException) {
        return CompletableFuture.supplyAsync(FunctionUtils.uncheckedSupplier(supplierWithException), (Executor)this.mainThreadExecutor).join();
    }

    public void execute(@Nonnull ThrowingRunnable<Throwable> throwingRunnable) {
        this.execute(() -> {
            throwingRunnable.run();
            return null;
        });
    }

    @Nonnull
    public ComponentMainThreadExecutor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public static class Extension
    implements BeforeAllCallback,
    AfterAllCallback {
        private final long shutdownTimeoutMillis;
        private TestingComponentMainThreadExecutor componentMainThreadTestExecutor;
        private ScheduledExecutorService innerExecutorService;

        public Extension() {
            this(500L);
        }

        public Extension(long shutdownTimeoutMillis) {
            this.shutdownTimeoutMillis = shutdownTimeoutMillis;
        }

        public void beforeAll(ExtensionContext extensionContext) throws Exception {
            this.innerExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.componentMainThreadTestExecutor = new TestingComponentMainThreadExecutor(ComponentMainThreadExecutorServiceAdapter.forSingleThreadExecutor(this.innerExecutorService));
        }

        public void afterAll(ExtensionContext extensionContext) throws Exception {
            ExecutorUtils.gracefulShutdown((long)this.shutdownTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.innerExecutorService});
        }

        public TestingComponentMainThreadExecutor getComponentMainThreadTestExecutor() {
            return this.componentMainThreadTestExecutor;
        }
    }
}

