/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.client.ClientUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ClientUtilsTest {
    @TempDir
    private static java.nio.file.Path temporaryFolder;
    private static BlobServer blobServer;

    @BeforeAll
    static void setup() throws IOException {
        Configuration config = new Configuration();
        blobServer = new BlobServer(config, TempDirUtils.newFolder((java.nio.file.Path)temporaryFolder), (BlobStore)new VoidBlobStore());
        blobServer.start();
    }

    @AfterAll
    static void teardown() throws IOException {
        if (blobServer != null) {
            blobServer.close();
        }
    }

    @Test
    void uploadAndSetUserJars() throws Exception {
        java.nio.file.Path tmpDir = TempDirUtils.newFolder((java.nio.file.Path)temporaryFolder).toPath();
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        List<Path> jars = Arrays.asList(new Path(Files.createFile(tmpDir.resolve("jar1.jar"), new FileAttribute[0]).toString()), new Path(Files.createFile(tmpDir.resolve("jar2.jar"), new FileAttribute[0]).toString()));
        jars.forEach(arg_0 -> ((JobGraph)jobGraph).addJar(arg_0));
        Assertions.assertThat((List)jobGraph.getUserJars()).hasSameSizeAs(jars);
        Assertions.assertThat((List)jobGraph.getUserJarBlobKeys()).isEmpty();
        ClientUtils.extractAndUploadExecutionPlanFiles((ExecutionPlan)jobGraph, () -> new BlobClient(new InetSocketAddress("localhost", blobServer.getPort()), new Configuration()));
        Assertions.assertThat((List)jobGraph.getUserJars()).hasSameSizeAs(jars);
        Assertions.assertThat((List)jobGraph.getUserJarBlobKeys()).hasSameSizeAs(jars);
        Assertions.assertThat(jobGraph.getUserJarBlobKeys().stream().distinct()).hasSameSizeAs(jars);
        for (PermanentBlobKey blobKey : jobGraph.getUserJarBlobKeys()) {
            blobServer.getFile(jobGraph.getJobID(), blobKey);
        }
    }

    @Test
    void uploadAndSetUserArtifacts() throws Exception {
        java.nio.file.Path tmpDir = TempDirUtils.newFolder((java.nio.file.Path)temporaryFolder).toPath();
        JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
        List<DistributedCache.DistributedCacheEntry> localArtifacts = Arrays.asList(new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art1"), new FileAttribute[0]).toString(), true, true), new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art2"), new FileAttribute[0]).toString(), true, false), new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art3"), new FileAttribute[0]).toString(), false, true), new DistributedCache.DistributedCacheEntry(Files.createFile(tmpDir.resolve("art4"), new FileAttribute[0]).toString(), true, false));
        List<DistributedCache.DistributedCacheEntry> distributedArtifacts = Collections.singletonList(new DistributedCache.DistributedCacheEntry("hdfs://localhost:1234/test", true, false));
        for (DistributedCache.DistributedCacheEntry entry2 : localArtifacts) {
            jobGraph.addUserArtifact(entry2.filePath, entry2);
        }
        for (DistributedCache.DistributedCacheEntry entry2 : distributedArtifacts) {
            jobGraph.addUserArtifact(entry2.filePath, entry2);
        }
        int totalNumArtifacts = localArtifacts.size() + distributedArtifacts.size();
        Assertions.assertThat((Map)jobGraph.getUserArtifacts()).hasSize(totalNumArtifacts);
        Assertions.assertThat(jobGraph.getUserArtifacts().values().stream().filter(entry -> entry.blobKey != null)).isEmpty();
        ClientUtils.extractAndUploadExecutionPlanFiles((ExecutionPlan)jobGraph, () -> new BlobClient(new InetSocketAddress("localhost", blobServer.getPort()), new Configuration()));
        Assertions.assertThat((Map)jobGraph.getUserArtifacts()).hasSize(totalNumArtifacts);
        Assertions.assertThat(jobGraph.getUserArtifacts().values().stream().filter(entry -> entry.blobKey != null)).hasSameSizeAs(localArtifacts);
        Assertions.assertThat(jobGraph.getUserArtifacts().values().stream().filter(entry -> entry.blobKey == null)).hasSameSizeAs(distributedArtifacts);
        Assertions.assertThat(jobGraph.getUserArtifacts().values().stream().map(entry -> entry.blobKey).distinct()).hasSize(localArtifacts.size() + 1);
        for (DistributedCache.DistributedCacheEntry original : localArtifacts) {
            ClientUtilsTest.assertState(original, (DistributedCache.DistributedCacheEntry)jobGraph.getUserArtifacts().get(original.filePath), false, jobGraph.getJobID());
        }
        for (DistributedCache.DistributedCacheEntry original : distributedArtifacts) {
            ClientUtilsTest.assertState(original, (DistributedCache.DistributedCacheEntry)jobGraph.getUserArtifacts().get(original.filePath), true, jobGraph.getJobID());
        }
    }

    private static void assertState(DistributedCache.DistributedCacheEntry original, DistributedCache.DistributedCacheEntry actual, boolean isBlobKeyNull, JobID jobId) throws Exception {
        Assertions.assertThat((boolean)actual.isZipped).isEqualTo(original.isZipped);
        Assertions.assertThat((Boolean)actual.isExecutable).isEqualTo((Object)original.isExecutable);
        Assertions.assertThat((String)actual.filePath).isEqualTo(original.filePath);
        Assertions.assertThat((actual.blobKey == null ? 1 : 0) != 0).isEqualTo(isBlobKeyNull);
        if (!isBlobKeyNull) {
            blobServer.getFile(jobId, (PermanentBlobKey)InstantiationUtil.deserializeObject((byte[])actual.blobKey, (ClassLoader)ClientUtilsTest.class.getClassLoader()));
        }
    }

    static {
        blobServer = null;
    }
}

