/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;

public class IntArrayList
extends AbstractList<Integer>
implements List<Integer>,
RandomAccess {
    public static final int DEFAULT_NULL_VALUE = Integer.MIN_VALUE;
    public static final int INITIAL_CAPACITY = 10;
    private final int nullValue;
    private int size = 0;
    private int[] elements;

    public IntArrayList() {
        this(10, Integer.MIN_VALUE);
    }

    public IntArrayList(int initialCapacity, int nullValue) {
        this.nullValue = nullValue;
        this.elements = new int[Math.max(initialCapacity, 10)];
    }

    public IntArrayList(int[] initialElements, int initialSize, int nullValue) {
        this.wrap(initialElements, initialSize);
        this.nullValue = nullValue;
    }

    public void wrap(int[] initialElements, int initialSize) {
        if (initialSize < 0 || initialSize > initialElements.length) {
            throw new IllegalArgumentException("illegal initial size " + initialSize + " for array length of " + initialElements.length);
        }
        this.elements = initialElements;
        this.size = initialSize;
    }

    public int nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size && this.elements.length > 10) {
            this.elements = Arrays.copyOf(this.elements, Math.max(10, this.size));
        }
    }

    @Override
    public Integer get(int index) {
        int value = this.getInt(index);
        return this.nullValue == value ? null : Integer.valueOf(value);
    }

    public int getInt(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    @Override
    public boolean add(Integer element) {
        return this.addInt(null == element ? this.nullValue : element);
    }

    public boolean addInt(int element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, Integer element) {
        this.addInt(index, null == element ? this.nullValue : element);
    }

    public void addInt(int index, int element) {
        this.checkIndexForAdd(index);
        int requiredSize = this.size + 1;
        this.ensureCapacityPrivate(requiredSize);
        if (index < this.size) {
            System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        }
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Integer set(int index, Integer element) {
        int previous = this.setInt(index, null == element ? this.nullValue : element);
        return this.nullValue == previous ? null : Integer.valueOf(previous);
    }

    public int setInt(int index, int element) {
        this.checkIndex(index);
        int previous = this.elements[index];
        this.elements[index] = element;
        return previous;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsInt(null == o ? this.nullValue : (Integer)o);
    }

    public boolean containsInt(int value) {
        return -1 != this.indexOf(value);
    }

    public int indexOf(int value) {
        int[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (value != elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        int[] elements = this.elements;
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != elements[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean addAll(IntArrayList list) {
        int numElements = list.size;
        if (numElements > 0) {
            this.ensureCapacityPrivate(this.size + numElements);
            System.arraycopy(list.elements, 0, this.elements, this.size, numElements);
            this.size += numElements;
            return true;
        }
        return false;
    }

    public boolean addAll(int index, IntArrayList list) {
        this.checkIndexForAdd(index);
        int numElements = list.size;
        if (numElements > 0) {
            int size = this.size;
            this.ensureCapacityPrivate(size + numElements);
            int[] elements = this.elements;
            for (int i = size - 1; i >= index; --i) {
                elements[i + numElements] = elements[i];
            }
            System.arraycopy(list.elements, 0, elements, index, numElements);
            this.size += numElements;
            return true;
        }
        return false;
    }

    public boolean containsAll(IntArrayList list) {
        int[] listElements = list.elements;
        int listNullValue = list.nullValue;
        boolean hasNulls = this.contains(null);
        int size = list.size;
        for (int i = 0; i < size; ++i) {
            int value = listElements[i];
            if (this.containsInt(value) || hasNulls && listNullValue == value) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(IntArrayList list) {
        int[] elements = this.elements;
        int size = this.size;
        if (size > 0) {
            if (list.isEmpty()) {
                this.size = 0;
                return true;
            }
            int nullValue = this.nullValue;
            boolean listHasNulls = list.contains(null);
            int[] filteredElements = null;
            int j = -1;
            for (int i = 0; i < size; ++i) {
                int value = elements[i];
                if (!(list.containsInt(value) || listHasNulls && nullValue == value)) {
                    if (null != filteredElements) continue;
                    filteredElements = Arrays.copyOf(elements, size);
                    j = i - 1;
                    continue;
                }
                if (null == filteredElements) continue;
                filteredElements[++j] = value;
            }
            if (null != filteredElements) {
                this.elements = filteredElements;
                this.size = j + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeAll(IntArrayList list) {
        int[] elements = this.elements;
        int size = this.size;
        if (size > 0 && !list.isEmpty()) {
            int nullValue = this.nullValue;
            boolean listHasNulls = list.contains(null);
            int[] filteredElements = null;
            int j = -1;
            for (int i = 0; i < size; ++i) {
                int value = elements[i];
                if (list.containsInt(value) || listHasNulls && nullValue == value) {
                    if (null != filteredElements) continue;
                    filteredElements = Arrays.copyOf(elements, size);
                    j = i - 1;
                    continue;
                }
                if (null == filteredElements) continue;
                filteredElements[++j] = value;
            }
            if (null != filteredElements) {
                this.elements = filteredElements;
                this.size = j + 1;
                return true;
            }
        }
        return false;
    }

    public boolean removeIfInt(IntPredicate filter2) {
        Objects.requireNonNull(filter2);
        int[] elements = this.elements;
        int size = this.size;
        if (size > 0) {
            int[] filteredElements = null;
            int j = -1;
            for (int i = 0; i < size; ++i) {
                int value = elements[i];
                if (filter2.test(value)) {
                    if (null != filteredElements) continue;
                    filteredElements = Arrays.copyOf(elements, size);
                    j = i - 1;
                    continue;
                }
                if (null == filteredElements) continue;
                filteredElements[++j] = value;
            }
            if (null != filteredElements) {
                this.elements = filteredElements;
                this.size = j + 1;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeInt(null == o ? this.nullValue : (Integer)o);
    }

    @Override
    public Integer remove(int index) {
        int value = this.removeAt(index);
        return this.nullValue == value ? null : Integer.valueOf(value);
    }

    public int removeAt(int index) {
        this.checkIndex(index);
        int value = this.elements[index];
        int moveCount = this.size - index - 1;
        if (moveCount > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moveCount);
        }
        --this.size;
        return value;
    }

    public int fastUnorderedRemove(int index) {
        this.checkIndex(index);
        int value = this.elements[index];
        this.elements[index] = this.elements[--this.size];
        return value;
    }

    public boolean removeInt(int value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean fastUnorderedRemoveInt(int value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.elements[index] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    public void pushInt(int element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
    }

    public int popInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public void forEachOrderedInt(IntConsumer action) {
        int[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept(elements[i]);
        }
    }

    public IntStream intStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public int[] toIntArray(int[] dst) {
        if (dst.length == this.size) {
            System.arraycopy(this.elements, 0, dst, 0, dst.length);
            return dst;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int requiredCapacity) {
        this.ensureCapacityPrivate(Math.max(requiredCapacity, 10));
    }

    public boolean equals(IntArrayList that) {
        if (that == this) {
            return true;
        }
        boolean isEqual = false;
        int size = this.size;
        if (size == that.size) {
            isEqual = true;
            int[] elements = this.elements;
            int[] thatElements = that.elements;
            for (int i = 0; i < size; ++i) {
                int thisValue = elements[i];
                int thatValue = thatElements[i];
                if (thisValue == thatValue || thisValue == this.nullValue && thatValue == that.nullValue) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    @Override
    public boolean equals(Object other) {
        List that;
        if (other == this) {
            return true;
        }
        boolean isEqual = false;
        if (other instanceof IntArrayList) {
            return this.equals((IntArrayList)other);
        }
        if (other instanceof List && this.size == (that = (List)other).size()) {
            isEqual = true;
            int i = 0;
            for (Object o : that) {
                Integer thatValue;
                Integer thisValue;
                if ((null == o || o instanceof Integer) && Objects.equals(thisValue = this.get(i++), thatValue = (Integer)o)) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int nullValue = this.nullValue;
        int[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            int value = elements[i];
            hashCode = 31 * hashCode + (nullValue == value ? 0 : Integer.hashCode(value));
        }
        return hashCode;
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        Objects.requireNonNull(action);
        int nullValue = this.nullValue;
        int[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            int value = elements[i];
            action.accept(nullValue != value ? Integer.valueOf(value) : null);
        }
    }

    public void forEachInt(IntConsumer action) {
        Objects.requireNonNull(action);
        int[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            action.accept(elements[i]);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int nullValue = this.nullValue;
        int[] elements = this.elements;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            int value = elements[i];
            sb.append(value != nullValue ? Integer.valueOf(value) : null).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    private void ensureCapacityPrivate(int requiredCapacity) {
        int currentCapacity = this.elements.length;
        if (requiredCapacity > currentCapacity) {
            int newCapacity;
            if (requiredCapacity > 0x7FFFFFF7) {
                throw new IllegalStateException("max capacity: 2147483639");
            }
            int n = newCapacity = currentCapacity > 10 ? currentCapacity : 10;
            while (newCapacity < requiredCapacity) {
                if ((newCapacity += newCapacity >> 1) >= 0 && newCapacity < 0x7FFFFFF7) continue;
                newCapacity = 0x7FFFFFF7;
            }
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, currentCapacity);
            this.elements = newElements;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }
}

