/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.exceptions.HandshakeException;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcActorTest;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcService;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcServiceConfiguration;
import org.apache.flink.runtime.rpc.pekko.PekkoUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.pekko.actor.ActorSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class PekkoRpcActorHandshakeTest {
    private static PekkoRpcService rpcService1;
    private static PekkoRpcService rpcService2;
    private static WrongVersionPekkoRpcService wrongVersionRpcService;

    PekkoRpcActorHandshakeTest() {
    }

    @BeforeAll
    static void setupClass() {
        ActorSystem actorSystem1 = PekkoUtils.createDefaultActorSystem();
        ActorSystem actorSystem2 = PekkoUtils.createDefaultActorSystem();
        ActorSystem wrongVersionActorSystem = PekkoUtils.createDefaultActorSystem();
        PekkoRpcServiceConfiguration rpcServiceConfig = PekkoRpcServiceConfiguration.defaultConfiguration();
        rpcService1 = new PekkoRpcService(actorSystem1, rpcServiceConfig);
        rpcService2 = new PekkoRpcService(actorSystem2, rpcServiceConfig);
        wrongVersionRpcService = new WrongVersionPekkoRpcService(wrongVersionActorSystem, PekkoRpcServiceConfiguration.defaultConfiguration());
    }

    @AfterAll
    static void teardownClass() throws Exception {
        ArrayList<CompletableFuture> terminationFutures = new ArrayList<CompletableFuture>(3);
        terminationFutures.add(rpcService1.closeAsync());
        terminationFutures.add(rpcService2.closeAsync());
        terminationFutures.add(wrongVersionRpcService.closeAsync());
        FutureUtils.waitForAll(terminationFutures).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testVersionMatchBetweenRpcComponents() throws Exception {
        PekkoRpcActorTest.DummyRpcEndpoint rpcEndpoint = new PekkoRpcActorTest.DummyRpcEndpoint((RpcService)rpcService1);
        int value = 42;
        rpcEndpoint.setFoobar(42);
        rpcEndpoint.start();
        try {
            PekkoRpcActorTest.DummyRpcGateway dummyRpcGateway = (PekkoRpcActorTest.DummyRpcGateway)rpcService2.connect(rpcEndpoint.getAddress(), PekkoRpcActorTest.DummyRpcGateway.class).get();
            Assertions.assertThat((Integer)dummyRpcGateway.foobar().get()).isEqualTo(42);
        }
        catch (Throwable throwable) {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{rpcEndpoint});
            throw throwable;
        }
        RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{rpcEndpoint});
    }

    @Test
    void testVersionMismatchBetweenRpcComponents() throws Exception {
        PekkoRpcActorTest.DummyRpcEndpoint rpcEndpoint = new PekkoRpcActorTest.DummyRpcEndpoint((RpcService)rpcService1);
        rpcEndpoint.start();
        try {
            Assertions.assertThatThrownBy(() -> wrongVersionRpcService.connect(rpcEndpoint.getAddress(), PekkoRpcActorTest.DummyRpcGateway.class).get()).extracting(ExceptionUtils::stripExecutionException).isInstanceOf(HandshakeException.class);
        }
        catch (Throwable throwable) {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{rpcEndpoint});
            throw throwable;
        }
        RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{rpcEndpoint});
    }

    @Test
    void testWrongGatewayEndpointConnection() throws Exception {
        PekkoRpcActorTest.DummyRpcEndpoint rpcEndpoint = new PekkoRpcActorTest.DummyRpcEndpoint((RpcService)rpcService1);
        rpcEndpoint.start();
        CompletableFuture futureGateway = rpcService2.connect(rpcEndpoint.getAddress(), WrongRpcGateway.class);
        try {
            Assertions.assertThatThrownBy(() -> futureGateway.get()).extracting(ExceptionUtils::stripExecutionException).isInstanceOf(HandshakeException.class);
        }
        catch (Throwable throwable) {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{rpcEndpoint});
            throw throwable;
        }
        RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{rpcEndpoint});
    }

    private static class WrongVersionPekkoRpcService
    extends PekkoRpcService {
        WrongVersionPekkoRpcService(ActorSystem actorSystem, PekkoRpcServiceConfiguration configuration) {
            super(actorSystem, configuration);
        }

        protected int getVersion() {
            return -1;
        }
    }

    private static interface WrongRpcGateway
    extends RpcGateway {
        public CompletableFuture<Boolean> barfoo();

        public void tell(String var1);
    }
}

