/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcServiceUtils;
import org.apache.flink.runtime.rpc.pekko.PekkoUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.japi.pf.ReceiveBuilder;
import org.apache.pekko.pattern.Patterns;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PekkoActorSystemTest {
    PekkoActorSystemTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shutsDownOnActorFailure() {
        ActorSystem actorSystem = PekkoUtils.createLocalActorSystem((Configuration)new Configuration());
        try {
            CompletableFuture terminationFuture = actorSystem.getWhenTerminated().toCompletableFuture();
            ActorRef actorRef = actorSystem.actorOf(Props.create(SimpleActor.class, (Object[])new Object[0]));
            FlinkException cause = new FlinkException("Flink test exception");
            actorRef.tell((Object)Fail.exceptionally((Throwable)cause), ActorRef.noSender());
            terminationFuture.join();
        }
        finally {
            PekkoUtils.terminateActorSystem((ActorSystem)actorSystem).join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void askTerminatedActorFailsWithRecipientTerminatedException() {
        ActorSystem actorSystem = PekkoUtils.createLocalActorSystem((Configuration)new Configuration());
        Duration timeout = Duration.ofSeconds(10L);
        try {
            ActorRef actorRef = actorSystem.actorOf(Props.create(SimpleActor.class, (Object[])new Object[0]));
            Patterns.gracefulStop((ActorRef)actorRef, (Duration)timeout).toCompletableFuture().join();
            CompletionStage result = Patterns.ask((ActorRef)actorRef, (Object)new Object(), (Duration)timeout);
            Assertions.assertThatThrownBy(() -> result.toCompletableFuture().get()).extracting(ExceptionUtils::stripExecutionException).matches(PekkoRpcServiceUtils::isRecipientTerminatedException);
        }
        finally {
            PekkoUtils.terminateActorSystem((ActorSystem)actorSystem).join();
        }
    }

    private static final class SimpleActor
    extends AbstractActor {
        private SimpleActor() {
        }

        public AbstractActor.Receive createReceive() {
            return ReceiveBuilder.create().match(Fail.class, this::handleFail).build();
        }

        private void handleFail(Fail fail) {
            throw new RuntimeException(fail.getErrorCause());
        }
    }

    private static final class Fail {
        private final Throwable errorCause;

        private Fail(Throwable errorCause) {
            this.errorCause = errorCause;
        }

        private Throwable getErrorCause() {
            return this.errorCause;
        }

        private static Fail exceptionally(Throwable errorCause) {
            return new Fail(errorCause);
        }
    }
}

