/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.queryablestate.messages.KvStateInternalRequest;
import org.apache.flink.queryablestate.messages.KvStateResponse;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.messages.MessageType;
import org.apache.flink.queryablestate.network.messages.RequestFailure;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageSerializerTest {
    private final ByteBufAllocator alloc = UnpooledByteBufAllocator.DEFAULT;

    MessageSerializerTest() {
    }

    @Test
    void testRequestSerialization() throws Exception {
        long requestId = 2147484984L;
        KvStateID kvStateId = new KvStateID();
        byte[] serializedKeyAndNamespace = this.randomByteArray(1024);
        KvStateInternalRequest request = new KvStateInternalRequest(kvStateId, serializedKeyAndNamespace);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeRequest((ByteBufAllocator)this.alloc, (long)requestId, (MessageBody)request);
        int frameLength = buf.readInt();
        Assertions.assertThat((Comparable)MessageSerializer.deserializeHeader((ByteBuf)buf)).isEqualTo((Object)MessageType.REQUEST);
        Assertions.assertThat((long)MessageSerializer.getRequestId((ByteBuf)buf)).isEqualTo(requestId);
        KvStateInternalRequest requestDeser = (KvStateInternalRequest)serializer.deserializeRequest(buf);
        Assertions.assertThat((int)buf.readerIndex()).isEqualTo(frameLength + 4);
        Assertions.assertThat((Comparable)requestDeser.getKvStateId()).isEqualTo((Object)kvStateId);
        Assertions.assertThat((byte[])requestDeser.getSerializedKeyAndNamespace()).isEqualTo((Object)serializedKeyAndNamespace);
    }

    @Test
    void testRequestSerializationWithZeroLengthKeyAndNamespace() throws Exception {
        long requestId = 2147484984L;
        KvStateID kvStateId = new KvStateID();
        byte[] serializedKeyAndNamespace = new byte[]{};
        KvStateInternalRequest request = new KvStateInternalRequest(kvStateId, serializedKeyAndNamespace);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeRequest((ByteBufAllocator)this.alloc, (long)requestId, (MessageBody)request);
        int frameLength = buf.readInt();
        Assertions.assertThat((Comparable)MessageSerializer.deserializeHeader((ByteBuf)buf)).isEqualTo((Object)MessageType.REQUEST);
        Assertions.assertThat((long)MessageSerializer.getRequestId((ByteBuf)buf)).isEqualTo(requestId);
        KvStateInternalRequest requestDeser = (KvStateInternalRequest)serializer.deserializeRequest(buf);
        Assertions.assertThat((int)buf.readerIndex()).isEqualTo(frameLength + 4);
        Assertions.assertThat((Comparable)requestDeser.getKvStateId()).isEqualTo((Object)kvStateId);
        Assertions.assertThat((byte[])requestDeser.getSerializedKeyAndNamespace()).isEqualTo((Object)serializedKeyAndNamespace);
    }

    @Test
    void testNullPointerExceptionOnNullSerializedKeyAndNamepsace() throws Exception {
        Assertions.assertThatThrownBy(() -> new KvStateInternalRequest(new KvStateID(), null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testResponseSerialization() throws Exception {
        long requestId = 2220210925L;
        byte[] serializedResult = this.randomByteArray(1024);
        KvStateResponse response = new KvStateResponse(serializedResult);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeResponse((ByteBufAllocator)this.alloc, (long)requestId, (MessageBody)response);
        int frameLength = buf.readInt();
        Assertions.assertThat((Comparable)MessageSerializer.deserializeHeader((ByteBuf)buf)).isEqualTo((Object)MessageType.REQUEST_RESULT);
        Assertions.assertThat((long)MessageSerializer.getRequestId((ByteBuf)buf)).isEqualTo(requestId);
        KvStateResponse responseDeser = (KvStateResponse)serializer.deserializeResponse(buf);
        Assertions.assertThat((int)buf.readerIndex()).isEqualTo(frameLength + 4);
        Assertions.assertThat((byte[])responseDeser.getContent()).isEqualTo((Object)serializedResult);
    }

    @Test
    void testResponseSerializationWithZeroLengthSerializedResult() throws Exception {
        byte[] serializedResult = new byte[]{};
        KvStateResponse response = new KvStateResponse(serializedResult);
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvStateInternalRequest.KvStateInternalRequestDeserializer(), (MessageDeserializer)new KvStateResponse.KvStateResponseDeserializer());
        ByteBuf buf = MessageSerializer.serializeResponse((ByteBufAllocator)this.alloc, (long)72727278L, (MessageBody)response);
        int frameLength = buf.readInt();
        Assertions.assertThat((Comparable)MessageSerializer.deserializeHeader((ByteBuf)buf)).isEqualTo((Object)MessageType.REQUEST_RESULT);
        Assertions.assertThat((long)MessageSerializer.getRequestId((ByteBuf)buf)).isEqualTo(72727278L);
        KvStateResponse responseDeser = (KvStateResponse)serializer.deserializeResponse(buf);
        Assertions.assertThat((int)buf.readerIndex()).isEqualTo(frameLength + 4);
        Assertions.assertThat((byte[])responseDeser.getContent()).isEqualTo((Object)serializedResult);
    }

    @Test
    void testNullPointerExceptionOnNullSerializedResult() throws Exception {
        Assertions.assertThatThrownBy(() -> new KvStateResponse((byte[])null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testKvStateRequestFailureSerialization() throws Exception {
        long requestId = 2148594869L;
        IllegalStateException cause = new IllegalStateException("Expected test");
        ByteBuf buf = MessageSerializer.serializeRequestFailure((ByteBufAllocator)this.alloc, (long)requestId, (Throwable)cause);
        int frameLength = buf.readInt();
        Assertions.assertThat((Comparable)MessageSerializer.deserializeHeader((ByteBuf)buf)).isEqualTo((Object)MessageType.REQUEST_FAILURE);
        RequestFailure requestFailure = MessageSerializer.deserializeRequestFailure((ByteBuf)buf);
        Assertions.assertThat((int)buf.readerIndex()).isEqualTo(frameLength + 4);
        Assertions.assertThat((long)requestFailure.getRequestId()).isEqualTo(requestId);
        Assertions.assertThat((Throwable)requestFailure.getCause()).isInstanceOf(cause.getClass());
        Assertions.assertThat((String)requestFailure.getCause().getMessage()).isEqualTo(cause.getMessage());
    }

    @Test
    void testServerFailureSerialization() throws Exception {
        IllegalStateException cause = new IllegalStateException("Expected test");
        ByteBuf buf = MessageSerializer.serializeServerFailure((ByteBufAllocator)this.alloc, (Throwable)cause);
        int frameLength = buf.readInt();
        Assertions.assertThat((Comparable)MessageSerializer.deserializeHeader((ByteBuf)buf)).isEqualTo((Object)MessageType.SERVER_FAILURE);
        Throwable request = MessageSerializer.deserializeServerFailure((ByteBuf)buf);
        Assertions.assertThat((int)buf.readerIndex()).isEqualTo(frameLength + 4);
        Assertions.assertThat((Throwable)request).isInstanceOf(cause.getClass());
        Assertions.assertThat((String)request.getMessage()).isEqualTo(cause.getMessage());
    }

    private byte[] randomByteArray(int capacity) {
        byte[] bytes = new byte[capacity];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }
}

