/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import java.nio.file.Path;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.core.testutils.AllCallbackWrapper;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.util.CheckpointStorageUtils;
import org.apache.flink.streaming.util.StateBackendUtils;
import org.apache.flink.test.junit5.InjectClusterClient;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

class HAQueryableStateRocksDBBackendITCase
extends AbstractQueryableStateTestBase {
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 2;
    private static final int QS_PROXY_PORT_RANGE_START = 9074;
    private static final int QS_SERVER_PORT_RANGE_START = 9079;
    @TempDir
    @Order(value=1)
    static Path tmpStateBackendDir;
    @TempDir
    @Order(value=2)
    static Path tmpHaStoragePath;
    @RegisterExtension
    @Order(value=3)
    static final AllCallbackWrapper<ZooKeeperExtension> ZK_RESOURCE;
    @RegisterExtension
    @Order(value=4)
    static final MiniClusterExtension MINI_CLUSTER_RESOURCE;

    HAQueryableStateRocksDBBackendITCase() {
    }

    @Override
    protected StreamExecutionEnvironment createEnv() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StateBackendUtils.configureRocksDBStateBackend((StreamExecutionEnvironment)env);
        CheckpointStorageUtils.configureFileSystemCheckpointStorage((StreamExecutionEnvironment)env, (String)tmpHaStoragePath.toUri().toString());
        return env;
    }

    @BeforeAll
    static void setup(@InjectClusterClient RestClusterClient<?> injectedClusterClient) throws Exception {
        client = new QueryableStateClient("localhost", 9074);
        clusterClient = injectedClusterClient;
    }

    @AfterAll
    static void tearDown() throws Exception {
        client.shutdownAndWait();
    }

    private static Configuration getConfig() {
        Configuration config = new Configuration();
        config.set(QueryableStateOptions.ENABLE_QUERYABLE_STATE_PROXY_SERVER, (Object)true);
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"4m"));
        config.set(TaskManagerOptions.MINI_CLUSTER_NUM_TASK_MANAGERS, (Object)2);
        config.set(TaskManagerOptions.NUM_TASK_SLOTS, (Object)2);
        config.set(QueryableStateOptions.CLIENT_NETWORK_THREADS, (Object)2);
        config.set(QueryableStateOptions.PROXY_NETWORK_THREADS, (Object)2);
        config.set(QueryableStateOptions.SERVER_NETWORK_THREADS, (Object)2);
        config.set(QueryableStateOptions.PROXY_PORT_RANGE, (Object)"9074-9076");
        config.set(QueryableStateOptions.SERVER_PORT_RANGE, (Object)"9079-9081");
        config.set(WebOptions.SUBMIT_ENABLE, (Object)false);
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)tmpHaStoragePath.toString());
        config.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)((ZooKeeperExtension)ZK_RESOURCE.getCustomExtension()).getConnectString());
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"zookeeper");
        return config;
    }

    static {
        ZK_RESOURCE = new AllCallbackWrapper((CustomExtension)new ZooKeeperExtension());
        MINI_CLUSTER_RESOURCE = new MiniClusterExtension(() -> new MiniClusterResourceConfiguration.Builder().setConfiguration(HAQueryableStateRocksDBBackendITCase.getConfig()).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(2).build());
    }
}

