/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.proxy;

import java.net.InetAddress;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.client.proxy.KvStateClientProxyImpl;
import org.apache.flink.queryablestate.network.stats.DisabledKvStateRequestStats;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobmaster.KvStateLocationOracle;
import org.apache.flink.runtime.query.KvStateLocation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class KvStateClientProxyImplTest {
    private KvStateClientProxyImpl kvStateClientProxy;

    KvStateClientProxyImplTest() {
    }

    @BeforeEach
    void setup() {
        this.kvStateClientProxy = new KvStateClientProxyImpl(InetAddress.getLoopbackAddress().getHostName(), Collections.singleton(0).iterator(), Integer.valueOf(1), Integer.valueOf(1), (KvStateRequestStats)new DisabledKvStateRequestStats());
    }

    @AfterEach
    void shutdown() {
        this.kvStateClientProxy.shutdown();
    }

    @Test
    void testKvStateLocationOracle() {
        JobID jobId1 = new JobID();
        TestingKvStateLocationOracle kvStateLocationOracle1 = new TestingKvStateLocationOracle();
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId1, (KvStateLocationOracle)kvStateLocationOracle1);
        JobID jobId2 = new JobID();
        TestingKvStateLocationOracle kvStateLocationOracle2 = new TestingKvStateLocationOracle();
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId2, (KvStateLocationOracle)kvStateLocationOracle2);
        Assertions.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(new JobID())).isNull();
        Assertions.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId1)).isEqualTo((Object)kvStateLocationOracle1);
        Assertions.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId2)).isEqualTo((Object)kvStateLocationOracle2);
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId1, null);
        Assertions.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId1)).isNull();
    }

    @Test
    void testLegacyCodePathPreference() {
        TestingKvStateLocationOracle kvStateLocationOracle = new TestingKvStateLocationOracle();
        this.kvStateClientProxy.updateKvStateLocationOracle(HighAvailabilityServices.DEFAULT_JOB_ID, (KvStateLocationOracle)kvStateLocationOracle);
        JobID jobId = new JobID();
        this.kvStateClientProxy.updateKvStateLocationOracle(jobId, (KvStateLocationOracle)new TestingKvStateLocationOracle());
        Assertions.assertThat((Object)this.kvStateClientProxy.getKvStateLocationOracle(jobId)).isEqualTo((Object)kvStateLocationOracle);
    }

    private static final class TestingKvStateLocationOracle
    implements KvStateLocationOracle {
        private TestingKvStateLocationOracle() {
        }

        public CompletableFuture<KvStateLocation> requestKvStateLocation(JobID jobId, String registrationName) {
            return null;
        }
    }
}

