/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.nio.ByteBuffer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.queryablestate.client.state.ImmutableReducingState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ImmutableReducingStateTest {
    private final ReducingStateDescriptor<Long> reducingStateDesc = new ReducingStateDescriptor("test", (ReduceFunction)new SumReduce(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private ReducingState<Long> reduceState;

    ImmutableReducingStateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        if (!this.reducingStateDesc.isSerializerInitialized()) {
            this.reducingStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        this.reduceState = (ReducingState)ImmutableReducingState.createState(this.reducingStateDesc, (byte[])ByteBuffer.allocate(8).putLong(42L).array());
    }

    @Test
    void testUpdate() throws Exception {
        long value = (Long)this.reduceState.get();
        Assertions.assertThat((long)value).isEqualTo(42L);
        Assertions.assertThatThrownBy(() -> this.reduceState.add((Object)54L)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testClear() throws Exception {
        long value = (Long)this.reduceState.get();
        Assertions.assertThat((long)value).isEqualTo(42L);
        Assertions.assertThatThrownBy(() -> this.reduceState.clear()).isInstanceOf(UnsupportedOperationException.class);
    }

    private static class SumReduce
    implements ReduceFunction<Long> {
        private static final long serialVersionUID = 6041237513913189144L;

        private SumReduce() {
        }

        public Long reduce(Long value1, Long value2) throws Exception {
            return value1 + value2;
        }
    }
}

