/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.client.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.queryablestate.client.state.ImmutableMapState;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ImmutableMapStateTest {
    private final MapStateDescriptor<Long, Long> mapStateDesc = new MapStateDescriptor("test", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    private MapState<Long, Long> mapState;

    ImmutableMapStateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        if (!this.mapStateDesc.isSerializerInitialized()) {
            this.mapStateDesc.initializeSerializerUnlessSet(new ExecutionConfig());
        }
        HashMap<Long, Long> initMap = new HashMap<Long, Long>();
        initMap.put(1L, 5L);
        initMap.put(2L, 5L);
        byte[] initSer = KvStateSerializer.serializeMap(initMap.entrySet(), (TypeSerializer)BasicTypeInfo.LONG_TYPE_INFO.createSerializer((SerializerConfig)new SerializerConfigImpl()), (TypeSerializer)BasicTypeInfo.LONG_TYPE_INFO.createSerializer((SerializerConfig)new SerializerConfigImpl()));
        this.mapState = (MapState)ImmutableMapState.createState(this.mapStateDesc, (byte[])initSer);
    }

    @Test
    void testPut() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> this.mapState.put((Object)2L, (Object)54L)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testPutAll() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        HashMap<Long, Long> nMap = new HashMap<Long, Long>();
        nMap.put(1L, 7L);
        nMap.put(2L, 7L);
        Assertions.assertThatThrownBy(() -> this.mapState.putAll(nMap)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testUpdate() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> this.mapState.put((Object)2L, (Object)54L)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testIterator() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> {
            Iterator iterator = this.mapState.iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testIterable() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> {
            Iterable iterable = this.mapState.entries();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Assertions.assertThat((long)((Long)((Map.Entry)iterator.next()).getValue())).isEqualTo(5L);
                iterator.remove();
            }
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testKeys() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> {
            Iterator iterator = this.mapState.keys().iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testValues() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> {
            Iterator iterator = this.mapState.values().iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testClear() throws Exception {
        Assertions.assertThat((boolean)this.mapState.contains((Object)1L)).isTrue();
        long value = (Long)this.mapState.get((Object)1L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThat((boolean)this.mapState.contains((Object)2L)).isTrue();
        value = (Long)this.mapState.get((Object)2L);
        Assertions.assertThat((long)value).isEqualTo(5L);
        Assertions.assertThatThrownBy(() -> this.mapState.clear()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testIsEmpty() throws Exception {
        Assertions.assertThat((boolean)this.mapState.isEmpty()).isFalse();
    }
}

