/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils.serializers.python;

import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;

class ArrayDataSerializerTest {
    ArrayDataSerializerTest() {
    }

    static class BaseArrayWithNullTest
    extends SerializerTestBase<ArrayData> {
        BaseArrayWithNullTest() {
        }

        protected TypeSerializer<ArrayData> createSerializer() {
            return new org.apache.flink.table.runtime.typeutils.serializers.python.ArrayDataSerializer((LogicalType)new IntType(), (TypeSerializer)IntSerializer.INSTANCE);
        }

        protected int getLength() {
            return -1;
        }

        protected Class<ArrayData> getTypeClass() {
            return ArrayData.class;
        }

        protected ArrayData[] getTestData() {
            BinaryArrayData array = new BinaryArrayData();
            BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 4);
            BinaryArrayWriter.NullSetter nullSetter = BinaryArrayWriter.createNullSetter((LogicalType)new IntType());
            nullSetter.setNull(writer, 0);
            nullSetter.setNull(writer, 1);
            writer.complete();
            return new BinaryArrayData[]{array};
        }
    }

    static class ArrayDataWithBinaryArrayTest
    extends SerializerTestBase<ArrayData> {
        ArrayDataWithBinaryArrayTest() {
        }

        protected TypeSerializer<ArrayData> createSerializer() {
            return new org.apache.flink.table.runtime.typeutils.serializers.python.ArrayDataSerializer((LogicalType)new ArrayType((LogicalType)new BigIntType()), (TypeSerializer)new org.apache.flink.table.runtime.typeutils.serializers.python.ArrayDataSerializer((LogicalType)new BigIntType(), (TypeSerializer)LongSerializer.INSTANCE));
        }

        protected int getLength() {
            return -1;
        }

        protected Class<ArrayData> getTypeClass() {
            return ArrayData.class;
        }

        protected ArrayData[] getTestData() {
            BinaryArrayData elementArray = BinaryArrayData.fromPrimitiveArray((long[])new long[]{100L});
            org.apache.flink.table.runtime.typeutils.serializers.python.ArrayDataSerializer elementTypeSerializer = new org.apache.flink.table.runtime.typeutils.serializers.python.ArrayDataSerializer((LogicalType)new BigIntType(), (TypeSerializer)LongSerializer.INSTANCE);
            BinaryArrayData array = new BinaryArrayData();
            BinaryArrayWriter writer = new BinaryArrayWriter(array, 1, 8);
            writer.writeArray(0, (ArrayData)elementArray, (ArrayDataSerializer)elementTypeSerializer);
            writer.complete();
            return new BinaryArrayData[]{array};
        }
    }

    static class BaseArrayWithPrimitiveTest
    extends SerializerTestBase<ArrayData> {
        BaseArrayWithPrimitiveTest() {
        }

        protected TypeSerializer<ArrayData> createSerializer() {
            return new org.apache.flink.table.runtime.typeutils.serializers.python.ArrayDataSerializer((LogicalType)new BigIntType(), (TypeSerializer)LongSerializer.INSTANCE);
        }

        protected int getLength() {
            return -1;
        }

        protected Class<ArrayData> getTypeClass() {
            return ArrayData.class;
        }

        protected ArrayData[] getTestData() {
            return new BinaryArrayData[]{BinaryArrayData.fromPrimitiveArray((long[])new long[]{100L})};
        }
    }
}

