/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.utils;

import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.utils.ByteArrayWrapper;
import org.apache.flink.streaming.api.utils.ByteArrayWrapperSerializer;

class ByteArrayWrapperSerializerTest
extends SerializerTestBase<ByteArrayWrapper> {
    private final Random rnd = new Random(346283764872L);
    private static final ByteArrayWrapper EMPTY_ARRAY = new ByteArrayWrapper(new byte[0]);

    ByteArrayWrapperSerializerTest() {
    }

    protected TypeSerializer<ByteArrayWrapper> createSerializer() {
        return new ByteArrayWrapperSerializer();
    }

    protected Class<ByteArrayWrapper> getTypeClass() {
        return ByteArrayWrapper.class;
    }

    protected int getLength() {
        return -1;
    }

    protected ByteArrayWrapper[] getTestData() {
        return new ByteArrayWrapper[]{EMPTY_ARRAY, this.randomByteArray(this.rnd.nextInt(0x100000)), this.randomByteArray(1), this.randomByteArray(2), this.randomByteArray(0x100000)};
    }

    private ByteArrayWrapper randomByteArray(int len) {
        byte[] data = new byte[len];
        this.rnd.nextBytes(data);
        return new ByteArrayWrapper(data);
    }
}

