/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.python.eventtime;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkOutput;

@Internal
public class PerElementWatermarkGenerator
implements WatermarkGenerator<Object> {
    private long maxTimestamp = Long.MIN_VALUE;

    public void onEvent(Object event, long eventTimestamp, WatermarkOutput output) {
        if (eventTimestamp > this.maxTimestamp) {
            this.maxTimestamp = eventTimestamp;
            output.emitWatermark(new Watermark(eventTimestamp));
        }
    }

    public void onPeriodicEmit(WatermarkOutput output) {
    }

    public static WatermarkGeneratorSupplier<Object> getSupplier() {
        return (WatermarkGeneratorSupplier & Serializable)ctx -> new PerElementWatermarkGenerator();
    }
}

