/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.row;

import java.io.IOException;
import java.util.HashMap;
import org.apache.flink.formats.parquet.ParquetBuilder;
import org.apache.flink.formats.parquet.ParquetWriterFactory;
import org.apache.flink.formats.parquet.row.ParquetRowDataWriter;
import org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class ParquetRowDataBuilder
extends ParquetWriter.Builder<RowData, ParquetRowDataBuilder> {
    private final RowType rowType;
    private final boolean utcTimestamp;

    public ParquetRowDataBuilder(OutputFile path, RowType rowType, boolean utcTimestamp) {
        super(path);
        this.rowType = rowType;
        this.utcTimestamp = utcTimestamp;
    }

    protected ParquetRowDataBuilder self() {
        return this;
    }

    protected WriteSupport<RowData> getWriteSupport(Configuration conf) {
        return new ParquetWriteSupport(conf);
    }

    public static ParquetWriterFactory<RowData> createWriterFactory(RowType rowType, Configuration conf, boolean utcTimestamp) {
        return new ParquetWriterFactory<RowData>(new FlinkParquetBuilder(rowType, conf, utcTimestamp));
    }

    private class ParquetWriteSupport
    extends WriteSupport<RowData> {
        private MessageType schema = null;
        private ParquetRowDataWriter writer;
        private Configuration conf;

        private ParquetWriteSupport(Configuration conf) {
            this.conf = conf;
            this.schema = ParquetSchemaConverter.convertToParquetMessageType("flink_schema", ParquetRowDataBuilder.this.rowType, conf);
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.schema, new HashMap());
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.writer = new ParquetRowDataWriter(recordConsumer, ParquetRowDataBuilder.this.rowType, (GroupType)this.schema, ParquetRowDataBuilder.this.utcTimestamp, this.conf);
        }

        public void write(RowData record) {
            try {
                this.writer.write(record);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class FlinkParquetBuilder
    implements ParquetBuilder<RowData> {
        private final RowType rowType;
        private final SerializableConfiguration configuration;
        private final boolean utcTimestamp;

        public FlinkParquetBuilder(RowType rowType, Configuration conf, boolean utcTimestamp) {
            this.rowType = rowType;
            this.configuration = new SerializableConfiguration(conf);
            this.utcTimestamp = utcTimestamp;
        }

        @Override
        public ParquetWriter<RowData> createWriter(OutputFile out) throws IOException {
            Configuration conf = this.configuration.conf();
            return ((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)new ParquetRowDataBuilder(out, this.rowType, this.utcTimestamp).withCompressionCodec(CompressionCodecName.fromConf((String)conf.get("parquet.compression", CompressionCodecName.SNAPPY.name())))).withRowGroupSize(ParquetOutputFormat.getBlockSize((Configuration)conf))).withPageSize(ParquetOutputFormat.getPageSize((Configuration)conf))).withDictionaryPageSize(ParquetOutputFormat.getDictionaryPageSize((Configuration)conf))).withMaxPaddingSize(conf.getInt("parquet.writer.max-padding", 0x800000))).withDictionaryEncoding(ParquetOutputFormat.getEnableDictionary((Configuration)conf))).withValidation(ParquetOutputFormat.getValidation((Configuration)conf))).withWriterVersion(ParquetOutputFormat.getWriterVersion((Configuration)conf))).withConf(conf)).build();
        }
    }
}

